/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.MaintenanceTrack;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TrackListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterTracksResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterTracksResponse> {
    private static final SdkField<List<MaintenanceTrack>> MAINTENANCE_TRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MaintenanceTracks").getter(DescribeClusterTracksResponse.getter(DescribeClusterTracksResponse::maintenanceTracks)).setter(DescribeClusterTracksResponse.setter(Builder::maintenanceTracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTracks").build(), ListTrait.builder().memberLocationName("MaintenanceTrack").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceTrack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrack").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterTracksResponse.getter(DescribeClusterTracksResponse::marker)).setter(DescribeClusterTracksResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACKS_FIELD, MARKER_FIELD));
    private final List<MaintenanceTrack> maintenanceTracks;
    private final String marker;

    private DescribeClusterTracksResponse(BuilderImpl builder) {
        super(builder);
        this.maintenanceTracks = builder.maintenanceTracks;
        this.marker = builder.marker;
    }

    public final boolean hasMaintenanceTracks() {
        return this.maintenanceTracks != null && !(this.maintenanceTracks instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceTrack> maintenanceTracks() {
        return this.maintenanceTracks;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaintenanceTracks() ? this.maintenanceTracks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterTracksResponse)) {
            return false;
        }
        DescribeClusterTracksResponse other = (DescribeClusterTracksResponse)((Object)obj);
        return this.hasMaintenanceTracks() == other.hasMaintenanceTracks() && Objects.equals(this.maintenanceTracks(), other.maintenanceTracks()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterTracksResponse").add("MaintenanceTracks", this.hasMaintenanceTracks() ? this.maintenanceTracks() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceTracks": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTracks()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterTracksResponse, T> g) {
        return obj -> g.apply((DescribeClusterTracksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceTrack> maintenanceTracks = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterTracksResponse model) {
            super(model);
            this.maintenanceTracks(model.maintenanceTracks);
            this.marker(model.marker);
        }

        public final List<MaintenanceTrack.Builder> getMaintenanceTracks() {
            List<MaintenanceTrack.Builder> result = TrackListCopier.copyToBuilder(this.maintenanceTracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceTracks(Collection<MaintenanceTrack.BuilderImpl> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copyFromBuilder(maintenanceTracks);
        }

        @Override
        @Transient
        public final Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copy(maintenanceTracks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder maintenanceTracks(MaintenanceTrack ... maintenanceTracks) {
            this.maintenanceTracks(Arrays.asList(maintenanceTracks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder> ... maintenanceTracks) {
            this.maintenanceTracks(Stream.of(maintenanceTracks).map(c -> (MaintenanceTrack)((MaintenanceTrack.Builder)MaintenanceTrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeClusterTracksResponse build() {
            return new DescribeClusterTracksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterTracksResponse> {
        public Builder maintenanceTracks(Collection<MaintenanceTrack> var1);

        public Builder maintenanceTracks(MaintenanceTrack ... var1);

        public Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder> ... var1);

        public Builder marker(String var1);
    }
}

