/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;

public class DescribeReservedNodesPublisher
implements SdkPublisher<DescribeReservedNodesResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodesPublisher(RedshiftAsyncClient client, DescribeReservedNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodesPublisher(RedshiftAsyncClient client, DescribeReservedNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodes() != null) {
                return response.reservedNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedNodesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedNodesResponse> nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesPublisher.this.client.describeReservedNodes(DescribeReservedNodesPublisher.this.firstRequest);
            }
            return DescribeReservedNodesPublisher.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

