/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo;
import software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfoListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePartnersResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribePartnersResponse> {
    private static final SdkField<List<PartnerIntegrationInfo>> PARTNER_INTEGRATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartnerIntegrationInfoList").getter(DescribePartnersResponse.getter(DescribePartnersResponse::partnerIntegrationInfoList)).setter(DescribePartnersResponse.setter(Builder::partnerIntegrationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerIntegrationInfoList").build(), ListTrait.builder().memberLocationName("PartnerIntegrationInfo").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnerIntegrationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerIntegrationInfo").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_INTEGRATION_INFO_LIST_FIELD));
    private final List<PartnerIntegrationInfo> partnerIntegrationInfoList;

    private DescribePartnersResponse(BuilderImpl builder) {
        super(builder);
        this.partnerIntegrationInfoList = builder.partnerIntegrationInfoList;
    }

    public final boolean hasPartnerIntegrationInfoList() {
        return this.partnerIntegrationInfoList != null && !(this.partnerIntegrationInfoList instanceof SdkAutoConstructList);
    }

    public final List<PartnerIntegrationInfo> partnerIntegrationInfoList() {
        return this.partnerIntegrationInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerIntegrationInfoList() ? this.partnerIntegrationInfoList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePartnersResponse)) {
            return false;
        }
        DescribePartnersResponse other = (DescribePartnersResponse)((Object)obj);
        return this.hasPartnerIntegrationInfoList() == other.hasPartnerIntegrationInfoList() && Objects.equals(this.partnerIntegrationInfoList(), other.partnerIntegrationInfoList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePartnersResponse").add("PartnerIntegrationInfoList", this.hasPartnerIntegrationInfoList() ? this.partnerIntegrationInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartnerIntegrationInfoList": {
                return Optional.ofNullable(clazz.cast(this.partnerIntegrationInfoList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePartnersResponse, T> g) {
        return obj -> g.apply((DescribePartnersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<PartnerIntegrationInfo> partnerIntegrationInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePartnersResponse model) {
            super(model);
            this.partnerIntegrationInfoList(model.partnerIntegrationInfoList);
        }

        public final Collection<PartnerIntegrationInfo.Builder> getPartnerIntegrationInfoList() {
            if (this.partnerIntegrationInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partnerIntegrationInfoList != null ? (Collection)this.partnerIntegrationInfoList.stream().map(PartnerIntegrationInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partnerIntegrationInfoList(Collection<PartnerIntegrationInfo> partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList = PartnerIntegrationInfoListCopier.copy(partnerIntegrationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerIntegrationInfoList(PartnerIntegrationInfo ... partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList(Arrays.asList(partnerIntegrationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerIntegrationInfoList(Consumer<PartnerIntegrationInfo.Builder> ... partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList(Stream.of(partnerIntegrationInfoList).map(c -> (PartnerIntegrationInfo)((PartnerIntegrationInfo.Builder)PartnerIntegrationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartnerIntegrationInfoList(Collection<PartnerIntegrationInfo.BuilderImpl> partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList = PartnerIntegrationInfoListCopier.copyFromBuilder(partnerIntegrationInfoList);
        }

        @Override
        public DescribePartnersResponse build() {
            return new DescribePartnersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePartnersResponse> {
        public Builder partnerIntegrationInfoList(Collection<PartnerIntegrationInfo> var1);

        public Builder partnerIntegrationInfoList(PartnerIntegrationInfo ... var1);

        public Builder partnerIntegrationInfoList(Consumer<PartnerIntegrationInfo.Builder> ... var1);
    }
}

