/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CopyClusterSnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSnapshotIdentifier").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::sourceSnapshotIdentifier)).setter(CopyClusterSnapshotRequest.setter(Builder::sourceSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSnapshotClusterIdentifier").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::sourceSnapshotClusterIdentifier)).setter(CopyClusterSnapshotRequest.setter(Builder::sourceSnapshotClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotClusterIdentifier").build()}).build();
    private static final SdkField<String> TARGET_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetSnapshotIdentifier").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::targetSnapshotIdentifier)).setter(CopyClusterSnapshotRequest.setter(Builder::targetSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSnapshotIdentifier").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::manualSnapshotRetentionPeriod)).setter(CopyClusterSnapshotRequest.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_IDENTIFIER_FIELD, SOURCE_SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, TARGET_SNAPSHOT_IDENTIFIER_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD));
    private final String sourceSnapshotIdentifier;
    private final String sourceSnapshotClusterIdentifier;
    private final String targetSnapshotIdentifier;
    private final Integer manualSnapshotRetentionPeriod;

    private CopyClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotIdentifier = builder.sourceSnapshotIdentifier;
        this.sourceSnapshotClusterIdentifier = builder.sourceSnapshotClusterIdentifier;
        this.targetSnapshotIdentifier = builder.targetSnapshotIdentifier;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
    }

    public String sourceSnapshotIdentifier() {
        return this.sourceSnapshotIdentifier;
    }

    public String sourceSnapshotClusterIdentifier() {
        return this.sourceSnapshotClusterIdentifier;
    }

    public String targetSnapshotIdentifier() {
        return this.targetSnapshotIdentifier;
    }

    public Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyClusterSnapshotRequest)) {
            return false;
        }
        CopyClusterSnapshotRequest other = (CopyClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotIdentifier(), other.sourceSnapshotIdentifier()) && Objects.equals(this.sourceSnapshotClusterIdentifier(), other.sourceSnapshotClusterIdentifier()) && Objects.equals(this.targetSnapshotIdentifier(), other.targetSnapshotIdentifier()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod());
    }

    public String toString() {
        return ToString.builder((String)"CopyClusterSnapshotRequest").add("SourceSnapshotIdentifier", (Object)this.sourceSnapshotIdentifier()).add("SourceSnapshotClusterIdentifier", (Object)this.sourceSnapshotClusterIdentifier()).add("TargetSnapshotIdentifier", (Object)this.targetSnapshotIdentifier()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotIdentifier()));
            }
            case "SourceSnapshotClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotClusterIdentifier()));
            }
            case "TargetSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotIdentifier()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyClusterSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotIdentifier;
        private String sourceSnapshotClusterIdentifier;
        private String targetSnapshotIdentifier;
        private Integer manualSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyClusterSnapshotRequest model) {
            super(model);
            this.sourceSnapshotIdentifier(model.sourceSnapshotIdentifier);
            this.sourceSnapshotClusterIdentifier(model.sourceSnapshotClusterIdentifier);
            this.targetSnapshotIdentifier(model.targetSnapshotIdentifier);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
        }

        public final String getSourceSnapshotIdentifier() {
            return this.sourceSnapshotIdentifier;
        }

        @Override
        public final Builder sourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
            return this;
        }

        public final void setSourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
        }

        public final String getSourceSnapshotClusterIdentifier() {
            return this.sourceSnapshotClusterIdentifier;
        }

        @Override
        public final Builder sourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
            return this;
        }

        public final void setSourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
        }

        public final String getTargetSnapshotIdentifier() {
            return this.targetSnapshotIdentifier;
        }

        @Override
        public final Builder targetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
            return this;
        }

        public final void setTargetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyClusterSnapshotRequest build() {
            return new CopyClusterSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyClusterSnapshotRequest> {
        public Builder sourceSnapshotIdentifier(String var1);

        public Builder sourceSnapshotClusterIdentifier(String var1);

        public Builder targetSnapshotIdentifier(String var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

