/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreFromClusterSnapshotRequest extends RedshiftRequest implements
        ToCopyableBuilder<RestoreFromClusterSnapshotRequest.Builder, RestoreFromClusterSnapshotRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::snapshotIdentifier)).setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RestoreFromClusterSnapshotRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RestoreFromClusterSnapshotRequest::allowVersionUpgrade)).setter(setter(Builder::allowVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build())
            .build();

    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::clusterSubnetGroupName))
            .setter(setter(Builder::clusterSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RestoreFromClusterSnapshotRequest::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::hsmClientCertificateIdentifier))
            .setter(setter(Builder::hsmClientCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::hsmConfigurationIdentifier))
            .setter(setter(Builder::hsmConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build())
            .build();

    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::elasticIp)).setter(setter(Builder::elasticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()).build();

    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::clusterParameterGroupName))
            .setter(setter(Builder::clusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupName").build())
            .build();

    private static final SdkField<List<String>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreFromClusterSnapshotRequest::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreFromClusterSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RestoreFromClusterSnapshotRequest::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RestoreFromClusterSnapshotRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RestoreFromClusterSnapshotRequest::enhancedVpcRouting)).setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::additionalInfo)).setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()).build();

    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RestoreFromClusterSnapshotRequest::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IamRoleArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IamRoleArn").build()).build()).build()).build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreFromClusterSnapshotRequest::snapshotScheduleIdentifier))
            .setter(setter(Builder::snapshotScheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RestoreFromClusterSnapshotRequest::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD,
            ALLOW_VERSION_UPGRADE_FIELD, CLUSTER_SUBNET_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, OWNER_ACCOUNT_FIELD,
            HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, ELASTIC_IP_FIELD,
            CLUSTER_PARAMETER_GROUP_NAME_FIELD, CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, KMS_KEY_ID_FIELD, NODE_TYPE_FIELD, ENHANCED_VPC_ROUTING_FIELD,
            ADDITIONAL_INFO_FIELD, IAM_ROLES_FIELD, MAINTENANCE_TRACK_NAME_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD,
            NUMBER_OF_NODES_FIELD));

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String snapshotClusterIdentifier;

    private final Integer port;

    private final String availabilityZone;

    private final Boolean allowVersionUpgrade;

    private final String clusterSubnetGroupName;

    private final Boolean publiclyAccessible;

    private final String ownerAccount;

    private final String hsmClientCertificateIdentifier;

    private final String hsmConfigurationIdentifier;

    private final String elasticIp;

    private final String clusterParameterGroupName;

    private final List<String> clusterSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String preferredMaintenanceWindow;

    private final Integer automatedSnapshotRetentionPeriod;

    private final Integer manualSnapshotRetentionPeriod;

    private final String kmsKeyId;

    private final String nodeType;

    private final Boolean enhancedVpcRouting;

    private final String additionalInfo;

    private final List<String> iamRoles;

    private final String maintenanceTrackName;

    private final String snapshotScheduleIdentifier;

    private final Integer numberOfNodes;

    private RestoreFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.ownerAccount = builder.ownerAccount;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.elasticIp = builder.elasticIp;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.nodeType = builder.nodeType;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.additionalInfo = builder.additionalInfo;
        this.iamRoles = builder.iamRoles;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.numberOfNodes = builder.numberOfNodes;
    }

    /**
     * <p>
     * The identifier of the cluster that will be created from restoring the snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Alphabetic characters must be lowercase.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be unique for all clusters within an AWS account.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the cluster that will be created from restoring the snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alphabetic characters must be lowercase.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be unique for all clusters within an AWS account.
     *         </p>
     *         </li>
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
     * </p>
     * <p>
     * Example: <code>my-snapshot-id</code>
     * </p>
     * 
     * @return The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.</p>
     *         <p>
     *         Example: <code>my-snapshot-id</code>
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a
     * policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * </p>
     * 
     * @return The name of the cluster the source snapshot was created from. This parameter is required if your IAM user
     *         has a policy containing a snapshot resource element that specifies anything other than * for the cluster
     *         name.
     */
    public String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The port number on which the cluster accepts connections.
     * </p>
     * <p>
     * Default: The same port as the original cluster.
     * </p>
     * <p>
     * Constraints: Must be between <code>1115</code> and <code>65535</code>.
     * </p>
     * 
     * @return The port number on which the cluster accepts connections.</p>
     *         <p>
     *         Default: The same port as the original cluster.
     *         </p>
     *         <p>
     *         Constraints: Must be between <code>1115</code> and <code>65535</code>.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon EC2 Availability Zone in which to restore the cluster.
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone.
     * </p>
     * <p>
     * Example: <code>us-east-2a</code>
     * </p>
     * 
     * @return The Amazon EC2 Availability Zone in which to restore the cluster.</p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone.
     *         </p>
     *         <p>
     *         Example: <code>us-east-2a</code>
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift
     * engine that is running on the cluster.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon
     *         Redshift engine that is running on the cluster. </p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean allowVersionUpgrade() {
        return allowVersionUpgrade;
    }

    /**
     * <p>
     * The name of the subnet group where you want to cluster restored.
     * </p>
     * <p>
     * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you
     * want the cluster restored.
     * </p>
     * 
     * @return The name of the subnet group where you want to cluster restored.</p>
     *         <p>
     *         A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name
     *         where you want the cluster restored.
     */
    public String clusterSubnetGroupName() {
        return clusterSubnetGroupName;
    }

    /**
     * <p>
     * If <code>true</code>, the cluster can be accessed from a public network.
     * </p>
     * 
     * @return If <code>true</code>, the cluster can be accessed from a public network.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not
     * own, optional if you own the snapshot.
     * </p>
     * 
     * @return The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot
     *         you do not own, optional if you own the snapshot.
     */
    public String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption
     * keys stored in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
     *         encryption keys stored in an HSM.
     */
    public String hsmClientCertificateIdentifier() {
        return hsmClientCertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to
     * retrieve and store keys in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can
     *         use to retrieve and store keys in an HSM.
     */
    public String hsmConfigurationIdentifier() {
        return hsmConfigurationIdentifier;
    }

    /**
     * <p>
     * The elastic IP (EIP) address for the cluster.
     * </p>
     * 
     * @return The elastic IP (EIP) address for the cluster.
     */
    public String elasticIp() {
        return elasticIp;
    }

    /**
     * <p>
     * The name of the parameter group to be associated with this cluster.
     * </p>
     * <p>
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group,
     * go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
     * Amazon Redshift Parameter Groups</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the parameter group to be associated with this cluster.</p>
     *         <p>
     *         Default: The default Amazon Redshift cluster parameter group. For information about the default parameter
     *         group, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
     *         Amazon Redshift Parameter Groups</a>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String clusterParameterGroupName() {
        return clusterParameterGroupName;
    }

    /**
     * Returns true if the ClusterSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasClusterSecurityGroups() {
        return clusterSecurityGroups != null && !(clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security groups to be associated with this cluster.
     * </p>
     * <p>
     * Default: The default cluster security group for Amazon Redshift.
     * </p>
     * <p>
     * Cluster security groups only apply to clusters outside of VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security groups to be associated with this cluster.</p>
     *         <p>
     *         Default: The default cluster security group for Amazon Redshift.
     *         </p>
     *         <p>
     *         Cluster security groups only apply to clusters outside of VPCs.
     */
    public List<String> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * </p>
     * <p>
     * Default: The default VPC security group is associated with the cluster.
     * </p>
     * <p>
     * VPC security groups only apply to clusters in VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
     *         <p>
     *         Default: The default VPC security group is associated with the cluster.
     *         </p>
     *         <p>
     *         VPC security groups only apply to clusters in VPCs.
     */
    public List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * Default: The value selected for the cluster from which the snapshot was taken. For more information about the
     * time blocks for each region, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
     * >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         Default: The value selected for the cluster from which the snapshot was taken. For more information about
     *         the time blocks for each region, see <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
     *         >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled.
     * Even if automated snapshots are disabled, you can still create manual snapshots when you want with
     * <a>CreateClusterSnapshot</a>.
     * </p>
     * <p>
     * Default: The value selected for the cluster from which the snapshot was taken.
     * </p>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     * </p>
     * 
     * @return The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
     *         disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want
     *         with <a>CreateClusterSnapshot</a>. </p>
     *         <p>
     *         Default: The value selected for the cluster from which the snapshot was taken.
     *         </p>
     *         <p>
     *         Constraints: Must be a value from 0 to 35.
     */
    public Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     * indefinitely. This setting doesn't change the retention period of existing snapshots.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     *         indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the
     * cluster that you restore from a shared snapshot.
     * </p>
     * 
     * @return The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in
     *         the cluster that you restore from a shared snapshot.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The node type that the restored cluster will be provisioned with.
     * </p>
     * <p>
     * Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using any
     * DS node type. In that case, you can choose to restore into another DS node type of the same size. For example,
     * you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
     * must restore into that same instance type and size. In other words, you can only restore a dc1.large instance
     * type into another dc1.large instance type or dc2.large instance type. You can't restore dc1.8xlarge to
     * dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For more information
     * about node types, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
     * About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * 
     * @return The node type that the restored cluster will be provisioned with.</p>
     *         <p>
     *         Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are
     *         using any DS node type. In that case, you can choose to restore into another DS node type of the same
     *         size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you
     *         have a DC instance type, you must restore into that same instance type and size. In other words, you can
     *         only restore a dc1.large instance type into another dc1.large instance type or dc2.large instance type.
     *         You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a
     *         dc2.8large cluster. For more information about node types, see <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"
     *         > About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
     *         Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public String additionalInfo() {
        return additionalInfo;
    }

    /**
     * Returns true if the IamRoles property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
     * services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM
     * roles in a single request.
     * </p>
     * <p>
     * A cluster can have up to 10 IAM roles associated at any time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIamRoles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other
     *         AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up
     *         to 10 IAM roles in a single request.</p>
     *         <p>
     *         A cluster can have up to 10 IAM roles associated at any time.
     */
    public List<String> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the
     * <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the cluster
     * that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the
     * current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source
     * cluster are on different tracks.
     * </p>
     * 
     * @return The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot
     *         inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different
     *         track than the cluster that was the source for the snapshot. For example, suppose that you take a
     *         snapshot of a cluster that is on the current track and then change the cluster to be on the trailing
     *         track. In this case, the snapshot and the source cluster are on different tracks.
     */
    public String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * A unique identifier for the snapshot schedule.
     * </p>
     * 
     * @return A unique identifier for the snapshot schedule.
     */
    public String snapshotScheduleIdentifier() {
        return snapshotScheduleIdentifier;
    }

    /**
     * <p>
     * The number of nodes specified when provisioning the restored cluster.
     * </p>
     * 
     * @return The number of nodes specified when provisioning the restored cluster.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoles());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(allowVersionUpgrade(), other.allowVersionUpgrade())
                && Objects.equals(clusterSubnetGroupName(), other.clusterSubnetGroupName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier())
                && Objects.equals(hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier())
                && Objects.equals(elasticIp(), other.elasticIp())
                && Objects.equals(clusterParameterGroupName(), other.clusterParameterGroupName())
                && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups())
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(additionalInfo(), other.additionalInfo()) && Objects.equals(iamRoles(), other.iamRoles())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier())
                && Objects.equals(numberOfNodes(), other.numberOfNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreFromClusterSnapshotRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("SnapshotIdentifier", snapshotIdentifier()).add("SnapshotClusterIdentifier", snapshotClusterIdentifier())
                .add("Port", port()).add("AvailabilityZone", availabilityZone())
                .add("AllowVersionUpgrade", allowVersionUpgrade()).add("ClusterSubnetGroupName", clusterSubnetGroupName())
                .add("PubliclyAccessible", publiclyAccessible()).add("OwnerAccount", ownerAccount())
                .add("HsmClientCertificateIdentifier", hsmClientCertificateIdentifier())
                .add("HsmConfigurationIdentifier", hsmConfigurationIdentifier()).add("ElasticIp", elasticIp())
                .add("ClusterParameterGroupName", clusterParameterGroupName())
                .add("ClusterSecurityGroups", clusterSecurityGroups()).add("VpcSecurityGroupIds", vpcSecurityGroupIds())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).add("KmsKeyId", kmsKeyId())
                .add("NodeType", nodeType()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("AdditionalInfo", additionalInfo()).add("IamRoles", iamRoles())
                .add("MaintenanceTrackName", maintenanceTrackName())
                .add("SnapshotScheduleIdentifier", snapshotScheduleIdentifier()).add("NumberOfNodes", numberOfNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AllowVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowVersionUpgrade()));
        case "ClusterSubnetGroupName":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroupName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "HsmClientCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(hsmClientCertificateIdentifier()));
        case "HsmConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(hsmConfigurationIdentifier()));
        case "ElasticIp":
            return Optional.ofNullable(clazz.cast(elasticIp()));
        case "ClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(clusterParameterGroupName()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "IamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "SnapshotScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotScheduleIdentifier()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromClusterSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreFromClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
        /**
         * <p>
         * The identifier of the cluster that will be created from restoring the snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Alphabetic characters must be lowercase.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be unique for all clusters within an AWS account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster that will be created from restoring the snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alphabetic characters must be lowercase.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be unique for all clusters within an AWS account.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
         * </p>
         * <p>
         * Example: <code>my-snapshot-id</code>
         * </p>
         * 
         * @param snapshotIdentifier
         *        The name of the snapshot from which to create the new cluster. This parameter isn't case
         *        sensitive.</p>
         *        <p>
         *        Example: <code>my-snapshot-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has
         * a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         * </p>
         * 
         * @param snapshotClusterIdentifier
         *        The name of the cluster the source snapshot was created from. This parameter is required if your IAM
         *        user has a policy containing a snapshot resource element that specifies anything other than * for the
         *        cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);

        /**
         * <p>
         * The port number on which the cluster accepts connections.
         * </p>
         * <p>
         * Default: The same port as the original cluster.
         * </p>
         * <p>
         * Constraints: Must be between <code>1115</code> and <code>65535</code>.
         * </p>
         * 
         * @param port
         *        The port number on which the cluster accepts connections.</p>
         *        <p>
         *        Default: The same port as the original cluster.
         *        </p>
         *        <p>
         *        Constraints: Must be between <code>1115</code> and <code>65535</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon EC2 Availability Zone in which to restore the cluster.
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone.
         * </p>
         * <p>
         * Example: <code>us-east-2a</code>
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon EC2 Availability Zone in which to restore the cluster.</p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone.
         *        </p>
         *        <p>
         *        Example: <code>us-east-2a</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon
         * Redshift engine that is running on the cluster.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param allowVersionUpgrade
         *        If <code>true</code>, major version upgrades can be applied during the maintenance window to the
         *        Amazon Redshift engine that is running on the cluster. </p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowVersionUpgrade(Boolean allowVersionUpgrade);

        /**
         * <p>
         * The name of the subnet group where you want to cluster restored.
         * </p>
         * <p>
         * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where
         * you want the cluster restored.
         * </p>
         * 
         * @param clusterSubnetGroupName
         *        The name of the subnet group where you want to cluster restored.</p>
         *        <p>
         *        A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group
         *        name where you want the cluster restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroupName(String clusterSubnetGroupName);

        /**
         * <p>
         * If <code>true</code>, the cluster can be accessed from a public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        If <code>true</code>, the cluster can be accessed from a public network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do
         * not own, optional if you own the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot
         *        you do not own, optional if you own the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         * encryption keys stored in an HSM.
         * </p>
         * 
         * @param hsmClientCertificateIdentifier
         *        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         *        encryption keys stored in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier);

        /**
         * <p>
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use
         * to retrieve and store keys in an HSM.
         * </p>
         * 
         * @param hsmConfigurationIdentifier
         *        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster
         *        can use to retrieve and store keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier);

        /**
         * <p>
         * The elastic IP (EIP) address for the cluster.
         * </p>
         * 
         * @param elasticIp
         *        The elastic IP (EIP) address for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        /**
         * <p>
         * The name of the parameter group to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter
         * group, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
         * Amazon Redshift Parameter Groups</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterParameterGroupName
         *        The name of the parameter group to be associated with this cluster.</p>
         *        <p>
         *        Default: The default Amazon Redshift cluster parameter group. For information about the default
         *        parameter group, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working
         *        with Amazon Redshift Parameter Groups</a>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroupName(String clusterParameterGroupName);

        /**
         * <p>
         * A list of security groups to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default cluster security group for Amazon Redshift.
         * </p>
         * <p>
         * Cluster security groups only apply to clusters outside of VPCs.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of security groups to be associated with this cluster.</p>
         *        <p>
         *        Default: The default cluster security group for Amazon Redshift.
         *        </p>
         *        <p>
         *        Cluster security groups only apply to clusters outside of VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups);

        /**
         * <p>
         * A list of security groups to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default cluster security group for Amazon Redshift.
         * </p>
         * <p>
         * Cluster security groups only apply to clusters outside of VPCs.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of security groups to be associated with this cluster.</p>
         *        <p>
         *        Default: The default cluster security group for Amazon Redshift.
         *        </p>
         *        <p>
         *        Cluster security groups only apply to clusters outside of VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(String... clusterSecurityGroups);

        /**
         * <p>
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * </p>
         * <p>
         * Default: The default VPC security group is associated with the cluster.
         * </p>
         * <p>
         * VPC security groups only apply to clusters in VPCs.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
         *        <p>
         *        Default: The default VPC security group is associated with the cluster.
         *        </p>
         *        <p>
         *        VPC security groups only apply to clusters in VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * </p>
         * <p>
         * Default: The default VPC security group is associated with the cluster.
         * </p>
         * <p>
         * VPC security groups only apply to clusters in VPCs.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
         *        <p>
         *        Default: The default VPC security group is associated with the cluster.
         *        </p>
         *        <p>
         *        VPC security groups only apply to clusters in VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The weekly time range (in UTC) during which automated cluster maintenance can occur.
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * Default: The value selected for the cluster from which the snapshot was taken. For more information about the
         * time blocks for each region, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
         * >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        Default: The value selected for the cluster from which the snapshot was taken. For more information
         *        about the time blocks for each region, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
         *        >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         * disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with
         * <a>CreateClusterSnapshot</a>.
         * </p>
         * <p>
         * Default: The value selected for the cluster from which the snapshot was taken.
         * </p>
         * <p>
         * Constraints: Must be a value from 0 to 35.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         *        disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you
         *        want with <a>CreateClusterSnapshot</a>. </p>
         *        <p>
         *        Default: The value selected for the cluster from which the snapshot was taken.
         *        </p>
         *        <p>
         *        Constraints: Must be a value from 0 to 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         * indefinitely. This setting doesn't change the retention period of existing snapshots.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         *        indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the
         * cluster that you restore from a shared snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data
         *        in the cluster that you restore from a shared snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The node type that the restored cluster will be provisioned with.
         * </p>
         * <p>
         * Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using
         * any DS node type. In that case, you can choose to restore into another DS node type of the same size. For
         * example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC
         * instance type, you must restore into that same instance type and size. In other words, you can only restore a
         * dc1.large instance type into another dc1.large instance type or dc2.large instance type. You can't restore
         * dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For
         * more information about node types, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
         * About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param nodeType
         *        The node type that the restored cluster will be provisioned with.</p>
         *        <p>
         *        Default: The node type of the cluster from which the snapshot was taken. You can modify this if you
         *        are using any DS node type. In that case, you can choose to restore into another DS node type of the
         *        same size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge.
         *        If you have a DC instance type, you must restore into that same instance type and size. In other
         *        words, you can only restore a dc1.large instance type into another dc1.large instance type or
         *        dc2.large instance type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
         *        cluster, then resize to a dc2.8large cluster. For more information about node types, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"
         *        > About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
         * services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10
         * IAM roles in a single request.
         * </p>
         * <p>
         * A cluster can have up to 10 IAM roles associated at any time.
         * </p>
         * 
         * @param iamRoles
         *        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
         *        other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can
         *        supply up to 10 IAM roles in a single request.</p>
         *        <p>
         *        A cluster can have up to 10 IAM roles associated at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<String> iamRoles);

        /**
         * <p>
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
         * services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10
         * IAM roles in a single request.
         * </p>
         * <p>
         * A cluster can have up to 10 IAM roles associated at any time.
         * </p>
         * 
         * @param iamRoles
         *        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
         *        other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can
         *        supply up to 10 IAM roles in a single request.</p>
         *        <p>
         *        A cluster can have up to 10 IAM roles associated at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(String... iamRoles);

        /**
         * <p>
         * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits
         * the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the
         * cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that
         * is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot
         * and the source cluster are on different tracks.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot
         *        inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a
         *        different track than the cluster that was the source for the snapshot. For example, suppose that you
         *        take a snapshot of a cluster that is on the current track and then change the cluster to be on the
         *        trailing track. In this case, the snapshot and the source cluster are on different tracks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * A unique identifier for the snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleIdentifier
         *        A unique identifier for the snapshot schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier);

        /**
         * <p>
         * The number of nodes specified when provisioning the restored cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of nodes specified when provisioning the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String snapshotClusterIdentifier;

        private Integer port;

        private String availabilityZone;

        private Boolean allowVersionUpgrade;

        private String clusterSubnetGroupName;

        private Boolean publiclyAccessible;

        private String ownerAccount;

        private String hsmClientCertificateIdentifier;

        private String hsmConfigurationIdentifier;

        private String elasticIp;

        private String clusterParameterGroupName;

        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private Integer automatedSnapshotRetentionPeriod;

        private Integer manualSnapshotRetentionPeriod;

        private String kmsKeyId;

        private String nodeType;

        private Boolean enhancedVpcRouting;

        private String additionalInfo;

        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private String maintenanceTrackName;

        private String snapshotScheduleIdentifier;

        private Integer numberOfNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromClusterSnapshotRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            port(model.port);
            availabilityZone(model.availabilityZone);
            allowVersionUpgrade(model.allowVersionUpgrade);
            clusterSubnetGroupName(model.clusterSubnetGroupName);
            publiclyAccessible(model.publiclyAccessible);
            ownerAccount(model.ownerAccount);
            hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            elasticIp(model.elasticIp);
            clusterParameterGroupName(model.clusterParameterGroupName);
            clusterSecurityGroups(model.clusterSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            kmsKeyId(model.kmsKeyId);
            nodeType(model.nodeType);
            enhancedVpcRouting(model.enhancedVpcRouting);
            additionalInfo(model.additionalInfo);
            iamRoles(model.iamRoles);
            maintenanceTrackName(model.maintenanceTrackName);
            snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            numberOfNodes(model.numberOfNodes);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getAllowVersionUpgrade() {
            return allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getClusterSubnetGroupName() {
            return clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getHsmClientCertificateIdentifier() {
            return hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getClusterParameterGroupName() {
            return clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final Collection<String> getIamRoles() {
            return iamRoles;
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getSnapshotScheduleIdentifier() {
            return snapshotScheduleIdentifier;
        }

        @Override
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromClusterSnapshotRequest build() {
            return new RestoreFromClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
