/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableSnapshotCopyRequest extends RedshiftRequest implements
        ToCopyableBuilder<EnableSnapshotCopyRequest.Builder, EnableSnapshotCopyRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableSnapshotCopyRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableSnapshotCopyRequest::destinationRegion)).setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EnableSnapshotCopyRequest::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> SNAPSHOT_COPY_GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableSnapshotCopyRequest::snapshotCopyGrantName)).setter(setter(Builder::snapshotCopyGrantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrantName").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EnableSnapshotCopyRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            DESTINATION_REGION_FIELD, RETENTION_PERIOD_FIELD, SNAPSHOT_COPY_GRANT_NAME_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD));

    private final String clusterIdentifier;

    private final String destinationRegion;

    private final Integer retentionPeriod;

    private final String snapshotCopyGrantName;

    private final Integer manualSnapshotRetentionPeriod;

    private EnableSnapshotCopyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The unique identifier of the source cluster to copy snapshots from.
     * </p>
     * <p>
     * Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy
     * enabled.
     * </p>
     * 
     * @return The unique identifier of the source cluster to copy snapshots from.</p>
     *         <p>
     *         Constraints: Must be the valid name of an existing cluster that does not already have cross-region
     *         snapshot copy enabled.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The destination AWS Region that you want to copy snapshots to.
     * </p>
     * <p>
     * Constraints: Must be the name of a valid AWS Region. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the
     * Amazon Web Services General Reference.
     * </p>
     * 
     * @return The destination AWS Region that you want to copy snapshots to.</p>
     *         <p>
     *         Constraints: Must be the name of a valid AWS Region. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a>
     *         in the Amazon Web Services General Reference.
     */
    public String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The number of days to retain automated snapshots in the destination region after they are copied from the source
     * region.
     * </p>
     * <p>
     * Default: 7.
     * </p>
     * <p>
     * Constraints: Must be at least 1 and no more than 35.
     * </p>
     * 
     * @return The number of days to retain automated snapshots in the destination region after they are copied from the
     *         source region.</p>
     *         <p>
     *         Default: 7.
     *         </p>
     *         <p>
     *         Constraints: Must be at least 1 and no more than 35.
     */
    public Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the
     * destination region.
     * </p>
     * 
     * @return The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to
     *         the destination region.
     */
    public String snapshotCopyGrantName() {
        return snapshotCopyGrantName;
    }

    /**
     * <p>
     * The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the
     * source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The number of days to retain newly copied snapshots in the destination AWS Region after they are copied
     *         from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely. </p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyGrantName());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSnapshotCopyRequest)) {
            return false;
        }
        EnableSnapshotCopyRequest other = (EnableSnapshotCopyRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snapshotCopyGrantName(), other.snapshotCopyGrantName())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableSnapshotCopyRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("DestinationRegion", destinationRegion()).add("RetentionPeriod", retentionPeriod())
                .add("SnapshotCopyGrantName", snapshotCopyGrantName())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "SnapshotCopyGrantName":
            return Optional.ofNullable(clazz.cast(snapshotCopyGrantName()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableSnapshotCopyRequest, T> g) {
        return obj -> g.apply((EnableSnapshotCopyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableSnapshotCopyRequest> {
        /**
         * <p>
         * The unique identifier of the source cluster to copy snapshots from.
         * </p>
         * <p>
         * Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot
         * copy enabled.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the source cluster to copy snapshots from.</p>
         *        <p>
         *        Constraints: Must be the valid name of an existing cluster that does not already have cross-region
         *        snapshot copy enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The destination AWS Region that you want to copy snapshots to.
         * </p>
         * <p>
         * Constraints: Must be the name of a valid AWS Region. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in
         * the Amazon Web Services General Reference.
         * </p>
         * 
         * @param destinationRegion
         *        The destination AWS Region that you want to copy snapshots to.</p>
         *        <p>
         *        Constraints: Must be the name of a valid AWS Region. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and
         *        Endpoints</a> in the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The number of days to retain automated snapshots in the destination region after they are copied from the
         * source region.
         * </p>
         * <p>
         * Default: 7.
         * </p>
         * <p>
         * Constraints: Must be at least 1 and no more than 35.
         * </p>
         * 
         * @param retentionPeriod
         *        The number of days to retain automated snapshots in the destination region after they are copied from
         *        the source region.</p>
         *        <p>
         *        Default: 7.
         *        </p>
         *        <p>
         *        Constraints: Must be at least 1 and no more than 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the
         * destination region.
         * </p>
         * 
         * @param snapshotCopyGrantName
         *        The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied
         *        to the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyGrantName(String snapshotCopyGrantName);

        /**
         * <p>
         * The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from
         * the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days to retain newly copied snapshots in the destination AWS Region after they are
         *        copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.
         *        </p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String destinationRegion;

        private Integer retentionPeriod;

        private String snapshotCopyGrantName;

        private Integer manualSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSnapshotCopyRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            destinationRegion(model.destinationRegion);
            retentionPeriod(model.retentionPeriod);
            snapshotCopyGrantName(model.snapshotCopyGrantName);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSnapshotCopyRequest build() {
            return new EnableSnapshotCopyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
