/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyScheduledActionRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyScheduledActionRequest.Builder, ModifyScheduledActionRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyScheduledActionRequest::scheduledActionName)).setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<ScheduledActionType> TARGET_ACTION_FIELD = SdkField
            .<ScheduledActionType> builder(MarshallingType.SDK_POJO).getter(getter(ModifyScheduledActionRequest::targetAction))
            .setter(setter(Builder::targetAction)).constructor(ScheduledActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAction").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyScheduledActionRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyScheduledActionRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyScheduledActionRequest::scheduledActionDescription))
            .setter(setter(Builder::scheduledActionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionDescription").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ModifyScheduledActionRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ModifyScheduledActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyScheduledActionRequest::enable)).setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD,
            TARGET_ACTION_FIELD, SCHEDULE_FIELD, IAM_ROLE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, ENABLE_FIELD));

    private final String scheduledActionName;

    private final ScheduledActionType targetAction;

    private final String schedule;

    private final String iamRole;

    private final String scheduledActionDescription;

    private final Instant startTime;

    private final Instant endTime;

    private final Boolean enable;

    private ModifyScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetAction = builder.targetAction;
        this.schedule = builder.schedule;
        this.iamRole = builder.iamRole;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.enable = builder.enable;
    }

    /**
     * <p>
     * The name of the scheduled action to modify.
     * </p>
     * 
     * @return The name of the scheduled action to modify.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * A modified JSON format of the scheduled action. For more information about this parameter, see
     * <a>ScheduledAction</a>.
     * </p>
     * 
     * @return A modified JSON format of the scheduled action. For more information about this parameter, see
     *         <a>ScheduledAction</a>.
     */
    public ScheduledActionType targetAction() {
        return targetAction;
    }

    /**
     * <p>
     * A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information about this
     * parameter, see <a>ScheduledAction</a>.
     * </p>
     * 
     * @return A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information
     *         about this parameter, see <a>ScheduledAction</a>.
     */
    public String schedule() {
        return schedule;
    }

    /**
     * <p>
     * A different IAM role to assume to run the target action. For more information about this parameter, see
     * <a>ScheduledAction</a>.
     * </p>
     * 
     * @return A different IAM role to assume to run the target action. For more information about this parameter, see
     *         <a>ScheduledAction</a>.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * A modified description of the scheduled action.
     * </p>
     * 
     * @return A modified description of the scheduled action.
     */
    public String scheduledActionDescription() {
        return scheduledActionDescription;
    }

    /**
     * <p>
     * A modified start time of the scheduled action. For more information about this parameter, see
     * <a>ScheduledAction</a>.
     * </p>
     * 
     * @return A modified start time of the scheduled action. For more information about this parameter, see
     *         <a>ScheduledAction</a>.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A modified end time of the scheduled action. For more information about this parameter, see
     * <a>ScheduledAction</a>.
     * </p>
     * 
     * @return A modified end time of the scheduled action. For more information about this parameter, see
     *         <a>ScheduledAction</a>.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled
     * action is disabled.
     * </p>
     * 
     * @return A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the
     *         scheduled action is disabled.
     */
    public Boolean enable() {
        return enable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(targetAction());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyScheduledActionRequest)) {
            return false;
        }
        ModifyScheduledActionRequest other = (ModifyScheduledActionRequest) obj;
        return Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(targetAction(), other.targetAction()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(scheduledActionDescription(), other.scheduledActionDescription())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(enable(), other.enable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyScheduledActionRequest").add("ScheduledActionName", scheduledActionName())
                .add("TargetAction", targetAction()).add("Schedule", schedule()).add("IamRole", iamRole())
                .add("ScheduledActionDescription", scheduledActionDescription()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Enable", enable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "TargetAction":
            return Optional.ofNullable(clazz.cast(targetAction()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "ScheduledActionDescription":
            return Optional.ofNullable(clazz.cast(scheduledActionDescription()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyScheduledActionRequest, T> g) {
        return obj -> g.apply((ModifyScheduledActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyScheduledActionRequest> {
        /**
         * <p>
         * The name of the scheduled action to modify.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * A modified JSON format of the scheduled action. For more information about this parameter, see
         * <a>ScheduledAction</a>.
         * </p>
         * 
         * @param targetAction
         *        A modified JSON format of the scheduled action. For more information about this parameter, see
         *        <a>ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAction(ScheduledActionType targetAction);

        /**
         * <p>
         * A modified JSON format of the scheduled action. For more information about this parameter, see
         * <a>ScheduledAction</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledActionType.Builder} avoiding the need
         * to create one manually via {@link ScheduledActionType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledActionType.Builder#build()} is called immediately and
         * its result is passed to {@link #targetAction(ScheduledActionType)}.
         * 
         * @param targetAction
         *        a consumer that will call methods on {@link ScheduledActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAction(ScheduledActionType)
         */
        default Builder targetAction(Consumer<ScheduledActionType.Builder> targetAction) {
            return targetAction(ScheduledActionType.builder().applyMutation(targetAction).build());
        }

        /**
         * <p>
         * A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information about
         * this parameter, see <a>ScheduledAction</a>.
         * </p>
         * 
         * @param schedule
         *        A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information
         *        about this parameter, see <a>ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * A different IAM role to assume to run the target action. For more information about this parameter, see
         * <a>ScheduledAction</a>.
         * </p>
         * 
         * @param iamRole
         *        A different IAM role to assume to run the target action. For more information about this parameter,
         *        see <a>ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * A modified description of the scheduled action.
         * </p>
         * 
         * @param scheduledActionDescription
         *        A modified description of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionDescription(String scheduledActionDescription);

        /**
         * <p>
         * A modified start time of the scheduled action. For more information about this parameter, see
         * <a>ScheduledAction</a>.
         * </p>
         * 
         * @param startTime
         *        A modified start time of the scheduled action. For more information about this parameter, see
         *        <a>ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A modified end time of the scheduled action. For more information about this parameter, see
         * <a>ScheduledAction</a>.
         * </p>
         * 
         * @param endTime
         *        A modified end time of the scheduled action. For more information about this parameter, see
         *        <a>ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the
         * scheduled action is disabled.
         * </p>
         * 
         * @param enable
         *        A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the
         *        scheduled action is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String scheduledActionName;

        private ScheduledActionType targetAction;

        private String schedule;

        private String iamRole;

        private String scheduledActionDescription;

        private Instant startTime;

        private Instant endTime;

        private Boolean enable;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyScheduledActionRequest model) {
            super(model);
            scheduledActionName(model.scheduledActionName);
            targetAction(model.targetAction);
            schedule(model.schedule);
            iamRole(model.iamRole);
            scheduledActionDescription(model.scheduledActionDescription);
            startTime(model.startTime);
            endTime(model.endTime);
            enable(model.enable);
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final ScheduledActionType.Builder getTargetAction() {
            return targetAction != null ? targetAction.toBuilder() : null;
        }

        @Override
        public final Builder targetAction(ScheduledActionType targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public final void setTargetAction(ScheduledActionType.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final String getScheduledActionDescription() {
            return scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Boolean getEnable() {
            return enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyScheduledActionRequest build() {
            return new ModifyScheduledActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
