/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An AWS Identity and Access Management (IAM) role that can be used by the associated Amazon Redshift cluster to access
 * other AWS services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterIamRole implements SdkPojo, Serializable, ToCopyableBuilder<ClusterIamRole.Builder, ClusterIamRole> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterIamRole::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterIamRole::applyStatus)).setter(setter(Builder::applyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            APPLY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final String applyStatus;

    private ClusterIamRole(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.applyStatus = builder.applyStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role, for example,
     * <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role, for example,
     *         <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A value that describes the status of the IAM role's association with an Amazon Redshift cluster.
     * </p>
     * <p>
     * The following are possible statuses and descriptions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>in-sync</code>: The role is available for use by the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>adding</code>: The role is in the process of being associated with the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>removing</code>: The role is in the process of being disassociated with the cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
     *         <p>
     *         The following are possible statuses and descriptions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>in-sync</code>: The role is available for use by the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>adding</code>: The role is in the process of being associated with the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>removing</code>: The role is in the process of being disassociated with the cluster.
     *         </p>
     *         </li>
     */
    public String applyStatus() {
        return applyStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(applyStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterIamRole)) {
            return false;
        }
        ClusterIamRole other = (ClusterIamRole) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(applyStatus(), other.applyStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterIamRole").add("IamRoleArn", iamRoleArn()).add("ApplyStatus", applyStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ApplyStatus":
            return Optional.ofNullable(clazz.cast(applyStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterIamRole, T> g) {
        return obj -> g.apply((ClusterIamRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterIamRole> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role, for example,
         * <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role, for example,
         *        <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A value that describes the status of the IAM role's association with an Amazon Redshift cluster.
         * </p>
         * <p>
         * The following are possible statuses and descriptions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>in-sync</code>: The role is available for use by the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>adding</code>: The role is in the process of being associated with the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>removing</code>: The role is in the process of being disassociated with the cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applyStatus
         *        A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
         *        <p>
         *        The following are possible statuses and descriptions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>in-sync</code>: The role is available for use by the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>adding</code>: The role is in the process of being associated with the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>removing</code>: The role is in the process of being disassociated with the cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyStatus(String applyStatus);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private String applyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterIamRole model) {
            iamRoleArn(model.iamRoleArn);
            applyStatus(model.applyStatus);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getApplyStatus() {
            return applyStatus;
        }

        @Override
        public final Builder applyStatus(String applyStatus) {
            this.applyStatus = applyStatus;
            return this;
        }

        public final void setApplyStatus(String applyStatus) {
            this.applyStatus = applyStatus;
        }

        @Override
        public ClusterIamRole build() {
            return new ClusterIamRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
