/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an AWS customer account authorized to restore a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountWithRestoreAccess implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountWithRestoreAccess.Builder, AccountWithRestoreAccess> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccountWithRestoreAccess::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ACCOUNT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccountWithRestoreAccess::accountAlias)).setter(setter(Builder::accountAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_ALIAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String accountAlias;

    private AccountWithRestoreAccess(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.accountAlias = builder.accountAlias;
    }

    /**
     * <p>
     * The identifier of an AWS customer account authorized to restore a snapshot.
     * </p>
     * 
     * @return The identifier of an AWS customer account authorized to restore a snapshot.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The identifier of an AWS support account authorized to restore a snapshot. For AWS support, the identifier is
     * <code>amazon-redshift-support</code>.
     * </p>
     * 
     * @return The identifier of an AWS support account authorized to restore a snapshot. For AWS support, the
     *         identifier is <code>amazon-redshift-support</code>.
     */
    public String accountAlias() {
        return accountAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountWithRestoreAccess)) {
            return false;
        }
        AccountWithRestoreAccess other = (AccountWithRestoreAccess) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(accountAlias(), other.accountAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountWithRestoreAccess").add("AccountId", accountId()).add("AccountAlias", accountAlias())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccountAlias":
            return Optional.ofNullable(clazz.cast(accountAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountWithRestoreAccess, T> g) {
        return obj -> g.apply((AccountWithRestoreAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountWithRestoreAccess> {
        /**
         * <p>
         * The identifier of an AWS customer account authorized to restore a snapshot.
         * </p>
         * 
         * @param accountId
         *        The identifier of an AWS customer account authorized to restore a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The identifier of an AWS support account authorized to restore a snapshot. For AWS support, the identifier is
         * <code>amazon-redshift-support</code>.
         * </p>
         * 
         * @param accountAlias
         *        The identifier of an AWS support account authorized to restore a snapshot. For AWS support, the
         *        identifier is <code>amazon-redshift-support</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAlias(String accountAlias);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String accountAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountWithRestoreAccess model) {
            accountId(model.accountId);
            accountAlias(model.accountAlias);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAccountAlias() {
            return accountAlias;
        }

        @Override
        public final Builder accountAlias(String accountAlias) {
            this.accountAlias = accountAlias;
            return this;
        }

        public final void setAccountAlias(String accountAlias) {
            this.accountAlias = accountAlias;
        }

        @Override
        public AccountWithRestoreAccess build() {
            return new AccountWithRestoreAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
