/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AccessToSnapshotDeniedException;
import software.amazon.awssdk.services.redshift.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteRequestSizeExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsLimitExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BucketNotFoundException;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterOnLatestRevisionException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CopyToRegionDisabledException;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DependentServiceRequestThrottlingException;
import software.amazon.awssdk.services.redshift.model.DependentServiceUnavailableException;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.InProgressTableRestoreQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IncompatibleOrderableOptionsException;
import software.amazon.awssdk.services.redshift.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.redshift.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterParameterGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSecurityGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotScheduleStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterTrackException;
import software.amazon.awssdk.services.redshift.model.InvalidElasticIpException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmClientCertificateStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmConfigurationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidReservedNodeStateException;
import software.amazon.awssdk.services.redshift.model.InvalidRestoreException;
import software.amazon.awssdk.services.redshift.model.InvalidRetentionPeriodException;
import software.amazon.awssdk.services.redshift.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.redshift.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduleException;
import software.amazon.awssdk.services.redshift.model.InvalidSnapshotCopyGrantStateException;
import software.amazon.awssdk.services.redshift.model.InvalidSubnetException;
import software.amazon.awssdk.services.redshift.model.InvalidSubscriptionStateException;
import software.amazon.awssdk.services.redshift.model.InvalidTableRestoreArgumentException;
import software.amazon.awssdk.services.redshift.model.InvalidTagException;
import software.amazon.awssdk.services.redshift.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.redshift.model.LimitExceededException;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyMigratedException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.ResizeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyEnabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleUpdateInProgressException;
import software.amazon.awssdk.services.redshift.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.redshift.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.redshift.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.redshift.model.SourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.redshift.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.redshift.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionEventIdNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionSeverityNotFoundException;
import software.amazon.awssdk.services.redshift.model.TableLimitExceededException;
import software.amazon.awssdk.services.redshift.model.TableRestoreNotFoundException;
import software.amazon.awssdk.services.redshift.model.TagLimitExceededException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.redshift.model.UnknownSnapshotCopyRegionException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOperationException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOptionException;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable;
import software.amazon.awssdk.services.redshift.transform.AcceptReservedNodeExchangeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchDeleteClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchModifyClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CancelResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CopyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterDbRevisionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterTracksRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterVersionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeLoggingStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeNodeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeOrderableClusterOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotCopyGrantsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotSchedulesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeStorageRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterDbRevisionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterIamRolesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotCopyRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PurchaseReservedNodeOfferingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RebootClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResetClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResizeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreTableFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RotateEncryptionKeyRequestMarshaller;

@SdkInternalApi
final class DefaultRedshiftClient
implements RedshiftClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRedshiftClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "redshift";
    }

    @Override
    public AcceptReservedNodeExchangeResponse acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) throws ReservedNodeNotFoundException, InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException, ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException, ReservedNodeAlreadyExistsException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AcceptReservedNodeExchangeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AcceptReservedNodeExchangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptReservedNodeExchange").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptReservedNodeExchangeRequest).withMarshaller((Marshaller)new AcceptReservedNodeExchangeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AuthorizeClusterSecurityGroupIngressResponse authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) throws ClusterSecurityGroupNotFoundException, InvalidClusterSecurityGroupStateException, AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeClusterSecurityGroupIngressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AuthorizeClusterSecurityGroupIngressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeClusterSecurityGroupIngress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeClusterSecurityGroupIngressRequest).withMarshaller((Marshaller)new AuthorizeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AuthorizeSnapshotAccessResponse authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) throws ClusterSnapshotNotFoundException, AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException, DependentServiceRequestThrottlingException, InvalidClusterSnapshotStateException, LimitExceededException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeSnapshotAccessResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AuthorizeSnapshotAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeSnapshotAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeSnapshotAccessRequest).withMarshaller((Marshaller)new AuthorizeSnapshotAccessRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchDeleteClusterSnapshotsResponse batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest) throws BatchDeleteRequestSizeExceededException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (BatchDeleteClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteClusterSnapshotsRequest).withMarshaller((Marshaller)new BatchDeleteClusterSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public BatchModifyClusterSnapshotsResponse batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) throws InvalidRetentionPeriodException, BatchModifyClusterSnapshotsLimitExceededException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchModifyClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (BatchModifyClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchModifyClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchModifyClusterSnapshotsRequest).withMarshaller((Marshaller)new BatchModifyClusterSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CancelResizeResponse cancelResize(CancelResizeRequest cancelResizeRequest) throws ClusterNotFoundException, ResizeNotFoundException, InvalidClusterStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelResizeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CancelResizeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelResize").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelResizeRequest).withMarshaller((Marshaller)new CancelResizeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyClusterSnapshotResponse copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest) throws ClusterSnapshotAlreadyExistsException, ClusterSnapshotNotFoundException, InvalidClusterSnapshotStateException, ClusterSnapshotQuotaExceededException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyClusterSnapshotRequest).withMarshaller((Marshaller)new CopyClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException, InsufficientClusterCapacityException, ClusterParameterGroupNotFoundException, ClusterSecurityGroupNotFoundException, ClusterQuotaExceededException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException, ClusterSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidClusterSubnetGroupStateException, InvalidSubnetException, UnauthorizedOperationException, HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException, InvalidElasticIpException, TagLimitExceededException, InvalidTagException, LimitExceededException, DependentServiceRequestThrottlingException, InvalidClusterTrackException, SnapshotScheduleNotFoundException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterParameterGroupResponse createClusterParameterGroup(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) throws ClusterParameterGroupQuotaExceededException, ClusterParameterGroupAlreadyExistsException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterParameterGroupRequest).withMarshaller((Marshaller)new CreateClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterSecurityGroupResponse createClusterSecurityGroup(CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) throws ClusterSecurityGroupAlreadyExistsException, ClusterSecurityGroupQuotaExceededException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSecurityGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateClusterSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSecurityGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterSecurityGroupRequest).withMarshaller((Marshaller)new CreateClusterSecurityGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterSnapshotResponse createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest) throws ClusterSnapshotAlreadyExistsException, InvalidClusterStateException, ClusterNotFoundException, ClusterSnapshotQuotaExceededException, TagLimitExceededException, InvalidTagException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterSnapshotRequest).withMarshaller((Marshaller)new CreateClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateClusterSubnetGroupResponse createClusterSubnetGroup(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) throws ClusterSubnetGroupAlreadyExistsException, ClusterSubnetGroupQuotaExceededException, ClusterSubnetQuotaExceededException, InvalidSubnetException, UnauthorizedOperationException, TagLimitExceededException, InvalidTagException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateClusterSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterSubnetGroupRequest).withMarshaller((Marshaller)new CreateClusterSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException, SubscriptionCategoryNotFoundException, SubscriptionSeverityNotFoundException, SourceNotFoundException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventSubscriptionRequest).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHsmClientCertificateResponse createHsmClientCertificate(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) throws HsmClientCertificateAlreadyExistsException, HsmClientCertificateQuotaExceededException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmClientCertificateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateHsmClientCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmClientCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHsmClientCertificateRequest).withMarshaller((Marshaller)new CreateHsmClientCertificateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHsmConfigurationResponse createHsmConfiguration(CreateHsmConfigurationRequest createHsmConfigurationRequest) throws HsmConfigurationAlreadyExistsException, HsmConfigurationQuotaExceededException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateHsmConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHsmConfigurationRequest).withMarshaller((Marshaller)new CreateHsmConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSnapshotCopyGrantResponse createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) throws SnapshotCopyGrantAlreadyExistsException, SnapshotCopyGrantQuotaExceededException, LimitExceededException, TagLimitExceededException, InvalidTagException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotCopyGrantResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateSnapshotCopyGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotCopyGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotCopyGrantRequest).withMarshaller((Marshaller)new CreateSnapshotCopyGrantRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSnapshotScheduleResponse createSnapshotSchedule(CreateSnapshotScheduleRequest createSnapshotScheduleRequest) throws SnapshotScheduleAlreadyExistsException, InvalidScheduleException, SnapshotScheduleQuotaExceededException, TagLimitExceededException, ScheduleDefinitionTypeUnsupportedException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotScheduleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateSnapshotScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotScheduleRequest).withMarshaller((Marshaller)new CreateSnapshotScheduleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws TagLimitExceededException, ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest).withMarshaller((Marshaller)new CreateTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, ClusterSnapshotAlreadyExistsException, ClusterSnapshotQuotaExceededException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterRequest).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterParameterGroupResponse deleteClusterParameterGroup(DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterParameterGroupRequest).withMarshaller((Marshaller)new DeleteClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterSecurityGroupResponse deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) throws InvalidClusterSecurityGroupStateException, ClusterSecurityGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSecurityGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteClusterSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSecurityGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterSecurityGroupRequest).withMarshaller((Marshaller)new DeleteClusterSecurityGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterSnapshotResponse deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterSnapshotRequest).withMarshaller((Marshaller)new DeleteClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterSubnetGroupResponse deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) throws InvalidClusterSubnetGroupStateException, InvalidClusterSubnetStateException, ClusterSubnetGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteClusterSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterSubnetGroupRequest).withMarshaller((Marshaller)new DeleteClusterSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws SubscriptionNotFoundException, InvalidSubscriptionStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventSubscriptionRequest).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHsmClientCertificateResponse deleteHsmClientCertificate(DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) throws InvalidHsmClientCertificateStateException, HsmClientCertificateNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmClientCertificateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteHsmClientCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmClientCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHsmClientCertificateRequest).withMarshaller((Marshaller)new DeleteHsmClientCertificateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHsmConfigurationResponse deleteHsmConfiguration(DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) throws InvalidHsmConfigurationStateException, HsmConfigurationNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteHsmConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHsmConfigurationRequest).withMarshaller((Marshaller)new DeleteHsmConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSnapshotCopyGrantResponse deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) throws InvalidSnapshotCopyGrantStateException, SnapshotCopyGrantNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotCopyGrantResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteSnapshotCopyGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotCopyGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotCopyGrantRequest).withMarshaller((Marshaller)new DeleteSnapshotCopyGrantRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSnapshotScheduleResponse deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) throws InvalidClusterSnapshotScheduleStateException, SnapshotScheduleNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotScheduleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteSnapshotScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotScheduleRequest).withMarshaller((Marshaller)new DeleteSnapshotScheduleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterDbRevisionsResponse describeClusterDbRevisions(DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) throws ClusterNotFoundException, InvalidClusterStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterDbRevisionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterDbRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterDbRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterDbRevisionsRequest).withMarshaller((Marshaller)new DescribeClusterDbRevisionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterParameterGroupsResponse describeClusterParameterGroups(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterParameterGroupsRequest).withMarshaller((Marshaller)new DescribeClusterParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterParameterGroupsIterable describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeClusterParameterGroupsRequest));
    }

    @Override
    public DescribeClusterParametersResponse describeClusterParameters(DescribeClusterParametersRequest describeClusterParametersRequest) throws ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterParametersRequest).withMarshaller((Marshaller)new DescribeClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterParametersIterable describeClusterParametersPaginator(DescribeClusterParametersRequest describeClusterParametersRequest) throws ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterParametersIterable(this, this.applyPaginatorUserAgent(describeClusterParametersRequest));
    }

    @Override
    public DescribeClusterSecurityGroupsResponse describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSecurityGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterSecurityGroupsRequest).withMarshaller((Marshaller)new DescribeClusterSecurityGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterSecurityGroupsIterable describeClusterSecurityGroupsPaginator(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterSecurityGroupsIterable(this, this.applyPaginatorUserAgent(describeClusterSecurityGroupsRequest));
    }

    @Override
    public DescribeClusterSnapshotsResponse describeClusterSnapshots(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws ClusterNotFoundException, ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterSnapshotsRequest).withMarshaller((Marshaller)new DescribeClusterSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterSnapshotsIterable describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws ClusterNotFoundException, ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterSnapshotsIterable(this, this.applyPaginatorUserAgent(describeClusterSnapshotsRequest));
    }

    @Override
    public DescribeClusterSubnetGroupsResponse describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws ClusterSubnetGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeClusterSubnetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterSubnetGroupsIterable describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws ClusterSubnetGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeClusterSubnetGroupsRequest));
    }

    @Override
    public DescribeClusterTracksResponse describeClusterTracks(DescribeClusterTracksRequest describeClusterTracksRequest) throws InvalidClusterTrackException, UnauthorizedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterTracksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterTracksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterTracks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterTracksRequest).withMarshaller((Marshaller)new DescribeClusterTracksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterVersionsResponse describeClusterVersions(DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClusterVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClusterVersionsRequest).withMarshaller((Marshaller)new DescribeClusterVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClusterVersionsIterable describeClusterVersionsPaginator(DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClusterVersionsIterable(this, this.applyPaginatorUserAgent(describeClusterVersionsRequest));
    }

    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClustersRequest).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClustersIterable describeClustersPaginator(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeClustersIterable(this, this.applyPaginatorUserAgent(describeClustersRequest));
    }

    @Override
    public DescribeDefaultClusterParametersResponse describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDefaultClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDefaultClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDefaultClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDefaultClusterParametersRequest).withMarshaller((Marshaller)new DescribeDefaultClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDefaultClusterParametersIterable describeDefaultClusterParametersPaginator(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeDefaultClusterParametersIterable(this, this.applyPaginatorUserAgent(describeDefaultClusterParametersRequest));
    }

    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSubscriptionsRequest).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeEventSubscriptionsIterable(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeHsmClientCertificatesResponse describeHsmClientCertificates(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmClientCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeHsmClientCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmClientCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHsmClientCertificatesRequest).withMarshaller((Marshaller)new DescribeHsmClientCertificatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeHsmClientCertificatesIterable describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeHsmClientCertificatesIterable(this, this.applyPaginatorUserAgent(describeHsmClientCertificatesRequest));
    }

    @Override
    public DescribeHsmConfigurationsResponse describeHsmConfigurations(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) throws HsmConfigurationNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeHsmConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHsmConfigurationsRequest).withMarshaller((Marshaller)new DescribeHsmConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeHsmConfigurationsIterable describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) throws HsmConfigurationNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeHsmConfigurationsIterable(this, this.applyPaginatorUserAgent(describeHsmConfigurationsRequest));
    }

    @Override
    public DescribeLoggingStatusResponse describeLoggingStatus(DescribeLoggingStatusRequest describeLoggingStatusRequest) throws ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoggingStatusResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoggingStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoggingStatusRequest).withMarshaller((Marshaller)new DescribeLoggingStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeNodeConfigurationOptionsResponse describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) throws ClusterSnapshotNotFoundException, InvalidClusterSnapshotStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNodeConfigurationOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeNodeConfigurationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeConfigurationOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodeConfigurationOptionsRequest).withMarshaller((Marshaller)new DescribeNodeConfigurationOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeNodeConfigurationOptionsIterable describeNodeConfigurationOptionsPaginator(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) throws ClusterSnapshotNotFoundException, InvalidClusterSnapshotStateException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeNodeConfigurationOptionsIterable(this, this.applyPaginatorUserAgent(describeNodeConfigurationOptionsRequest));
    }

    @Override
    public DescribeOrderableClusterOptionsResponse describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableClusterOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeOrderableClusterOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableClusterOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableClusterOptionsRequest).withMarshaller((Marshaller)new DescribeOrderableClusterOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeOrderableClusterOptionsIterable describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeOrderableClusterOptionsIterable(this, this.applyPaginatorUserAgent(describeOrderableClusterOptionsRequest));
    }

    @Override
    public DescribeReservedNodeOfferingsResponse describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodeOfferingsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReservedNodeOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodeOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedNodeOfferingsRequest).withMarshaller((Marshaller)new DescribeReservedNodeOfferingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReservedNodeOfferingsIterable describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeReservedNodeOfferingsIterable(this, this.applyPaginatorUserAgent(describeReservedNodeOfferingsRequest));
    }

    @Override
    public DescribeReservedNodesResponse describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) throws ReservedNodeNotFoundException, DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReservedNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedNodesRequest).withMarshaller((Marshaller)new DescribeReservedNodesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReservedNodesIterable describeReservedNodesPaginator(DescribeReservedNodesRequest describeReservedNodesRequest) throws ReservedNodeNotFoundException, DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return new DescribeReservedNodesIterable(this, this.applyPaginatorUserAgent(describeReservedNodesRequest));
    }

    @Override
    public DescribeResizeResponse describeResize(DescribeResizeRequest describeResizeRequest) throws ClusterNotFoundException, ResizeNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeResizeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeResizeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResize").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResizeRequest).withMarshaller((Marshaller)new DescribeResizeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSnapshotCopyGrantsResponse describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) throws SnapshotCopyGrantNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotCopyGrantsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeSnapshotCopyGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotCopyGrants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotCopyGrantsRequest).withMarshaller((Marshaller)new DescribeSnapshotCopyGrantsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSnapshotSchedulesResponse describeSnapshotSchedules(DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotSchedulesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeSnapshotSchedulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotSchedules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotSchedulesRequest).withMarshaller((Marshaller)new DescribeSnapshotSchedulesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStorageResponse describeStorage(DescribeStorageRequest describeStorageRequest) throws AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStorageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStorageRequest).withMarshaller((Marshaller)new DescribeStorageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTableRestoreStatusResponse describeTableRestoreStatus(DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) throws TableRestoreNotFoundException, ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTableRestoreStatusResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTableRestoreStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableRestoreStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTableRestoreStatusRequest).withMarshaller((Marshaller)new DescribeTableRestoreStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableLoggingResponse disableLogging(DisableLoggingRequest disableLoggingRequest) throws ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableLoggingResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DisableLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLogging").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableLoggingRequest).withMarshaller((Marshaller)new DisableLoggingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableSnapshotCopyResponse disableSnapshotCopy(DisableSnapshotCopyRequest disableSnapshotCopyRequest) throws ClusterNotFoundException, SnapshotCopyAlreadyDisabledException, InvalidClusterStateException, UnauthorizedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableSnapshotCopyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DisableSnapshotCopyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSnapshotCopy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableSnapshotCopyRequest).withMarshaller((Marshaller)new DisableSnapshotCopyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableLoggingResponse enableLogging(EnableLoggingRequest enableLoggingRequest) throws ClusterNotFoundException, BucketNotFoundException, InsufficientS3BucketPolicyException, InvalidS3KeyPrefixException, InvalidS3BucketNameException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableLoggingResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnableLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLogging").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableLoggingRequest).withMarshaller((Marshaller)new EnableLoggingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableSnapshotCopyResponse enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest) throws IncompatibleOrderableOptionsException, InvalidClusterStateException, ClusterNotFoundException, CopyToRegionDisabledException, SnapshotCopyAlreadyEnabledException, UnknownSnapshotCopyRegionException, UnauthorizedOperationException, SnapshotCopyGrantNotFoundException, LimitExceededException, DependentServiceRequestThrottlingException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableSnapshotCopyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnableSnapshotCopyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSnapshotCopy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableSnapshotCopyRequest).withMarshaller((Marshaller)new EnableSnapshotCopyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetClusterCredentialsResponse getClusterCredentials(GetClusterCredentialsRequest getClusterCredentialsRequest) throws ClusterNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetClusterCredentialsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetClusterCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClusterCredentials").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getClusterCredentialsRequest).withMarshaller((Marshaller)new GetClusterCredentialsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetReservedNodeExchangeOfferingsResponse getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) throws ReservedNodeNotFoundException, InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException, ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReservedNodeExchangeOfferingsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetReservedNodeExchangeOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservedNodeExchangeOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservedNodeExchangeOfferingsRequest).withMarshaller((Marshaller)new GetReservedNodeExchangeOfferingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterResponse modifyCluster(ModifyClusterRequest modifyClusterRequest) throws InvalidClusterStateException, InvalidClusterSecurityGroupStateException, ClusterNotFoundException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException, ClusterSecurityGroupNotFoundException, ClusterParameterGroupNotFoundException, InsufficientClusterCapacityException, UnsupportedOptionException, UnauthorizedOperationException, HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException, ClusterAlreadyExistsException, LimitExceededException, DependentServiceRequestThrottlingException, InvalidElasticIpException, TableLimitExceededException, InvalidClusterTrackException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterRequest).withMarshaller((Marshaller)new ModifyClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterDbRevisionResponse modifyClusterDbRevision(ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) throws ClusterNotFoundException, ClusterOnLatestRevisionException, InvalidClusterStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterDbRevisionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterDbRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterDbRevision").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterDbRevisionRequest).withMarshaller((Marshaller)new ModifyClusterDbRevisionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterIamRolesResponse modifyClusterIamRoles(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) throws InvalidClusterStateException, ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterIamRolesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterIamRolesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterIamRoles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterIamRolesRequest).withMarshaller((Marshaller)new ModifyClusterIamRolesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterMaintenanceResponse modifyClusterMaintenance(ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) throws ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterMaintenanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterMaintenanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterMaintenance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterMaintenanceRequest).withMarshaller((Marshaller)new ModifyClusterMaintenanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterParameterGroupResponse modifyClusterParameterGroup(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) throws ClusterParameterGroupNotFoundException, InvalidClusterParameterGroupStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterParameterGroupRequest).withMarshaller((Marshaller)new ModifyClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterSnapshotResponse modifyClusterSnapshot(ModifyClusterSnapshotRequest modifyClusterSnapshotRequest) throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterSnapshotRequest).withMarshaller((Marshaller)new ModifyClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterSnapshotScheduleResponse modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) throws ClusterNotFoundException, SnapshotScheduleNotFoundException, InvalidClusterSnapshotScheduleStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotScheduleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterSnapshotScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshotSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterSnapshotScheduleRequest).withMarshaller((Marshaller)new ModifyClusterSnapshotScheduleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyClusterSubnetGroupResponse modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) throws ClusterSubnetGroupNotFoundException, ClusterSubnetQuotaExceededException, SubnetAlreadyInUseException, InvalidSubnetException, UnauthorizedOperationException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyClusterSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClusterSubnetGroupRequest).withMarshaller((Marshaller)new ModifyClusterSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws SubscriptionNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException, SubscriptionCategoryNotFoundException, SubscriptionSeverityNotFoundException, SourceNotFoundException, InvalidSubscriptionStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyEventSubscriptionRequest).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifySnapshotCopyRetentionPeriodResponse modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) throws ClusterNotFoundException, SnapshotCopyDisabledException, UnauthorizedOperationException, InvalidClusterStateException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotCopyRetentionPeriodResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifySnapshotCopyRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotCopyRetentionPeriod").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifySnapshotCopyRetentionPeriodRequest).withMarshaller((Marshaller)new ModifySnapshotCopyRetentionPeriodRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifySnapshotScheduleResponse modifySnapshotSchedule(ModifySnapshotScheduleRequest modifySnapshotScheduleRequest) throws InvalidScheduleException, SnapshotScheduleNotFoundException, SnapshotScheduleUpdateInProgressException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotScheduleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifySnapshotScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifySnapshotScheduleRequest).withMarshaller((Marshaller)new ModifySnapshotScheduleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PurchaseReservedNodeOfferingResponse purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) throws ReservedNodeOfferingNotFoundException, ReservedNodeAlreadyExistsException, ReservedNodeQuotaExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurchaseReservedNodeOfferingResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PurchaseReservedNodeOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedNodeOffering").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseReservedNodeOfferingRequest).withMarshaller((Marshaller)new PurchaseReservedNodeOfferingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootClusterResponse rebootCluster(RebootClusterRequest rebootClusterRequest) throws InvalidClusterStateException, ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RebootClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootClusterRequest).withMarshaller((Marshaller)new RebootClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResetClusterParameterGroupResponse resetClusterParameterGroup(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResetClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetClusterParameterGroupRequest).withMarshaller((Marshaller)new ResetClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResizeClusterResponse resizeCluster(ResizeClusterRequest resizeClusterRequest) throws InvalidClusterStateException, ClusterNotFoundException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException, InsufficientClusterCapacityException, UnsupportedOptionException, UnsupportedOperationException, UnauthorizedOperationException, LimitExceededException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResizeClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResizeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResizeCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resizeClusterRequest).withMarshaller((Marshaller)new ResizeClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreFromClusterSnapshotResponse restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) throws AccessToSnapshotDeniedException, ClusterAlreadyExistsException, ClusterSnapshotNotFoundException, ClusterQuotaExceededException, InsufficientClusterCapacityException, InvalidClusterSnapshotStateException, InvalidRestoreException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException, InvalidVpcNetworkStateException, InvalidClusterSubnetGroupStateException, InvalidSubnetException, ClusterSubnetGroupNotFoundException, UnauthorizedOperationException, HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException, InvalidElasticIpException, ClusterParameterGroupNotFoundException, ClusterSecurityGroupNotFoundException, LimitExceededException, DependentServiceRequestThrottlingException, InvalidClusterTrackException, SnapshotScheduleNotFoundException, TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreFromClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreFromClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreFromClusterSnapshotRequest).withMarshaller((Marshaller)new RestoreFromClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreTableFromClusterSnapshotResponse restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) throws ClusterSnapshotNotFoundException, InProgressTableRestoreQuotaExceededException, InvalidClusterSnapshotStateException, InvalidTableRestoreArgumentException, ClusterNotFoundException, InvalidClusterStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreTableFromClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreTableFromClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreTableFromClusterSnapshotRequest).withMarshaller((Marshaller)new RestoreTableFromClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RevokeClusterSecurityGroupIngressResponse revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) throws ClusterSecurityGroupNotFoundException, AuthorizationNotFoundException, InvalidClusterSecurityGroupStateException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeClusterSecurityGroupIngressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RevokeClusterSecurityGroupIngressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeClusterSecurityGroupIngress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeClusterSecurityGroupIngressRequest).withMarshaller((Marshaller)new RevokeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RevokeSnapshotAccessResponse revokeSnapshotAccess(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) throws AccessToSnapshotDeniedException, AuthorizationNotFoundException, ClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeSnapshotAccessResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RevokeSnapshotAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeSnapshotAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeSnapshotAccessRequest).withMarshaller((Marshaller)new RevokeSnapshotAccessRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RotateEncryptionKeyResponse rotateEncryptionKey(RotateEncryptionKeyRequest rotateEncryptionKeyRequest) throws ClusterNotFoundException, InvalidClusterStateException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException, RedshiftException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RotateEncryptionKeyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RotateEncryptionKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RotateEncryptionKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rotateEncryptionKeyRequest).withMarshaller((Marshaller)new RotateEncryptionKeyRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmConfigurationStateFault").exceptionBuilderSupplier(InvalidHsmConfigurationStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleAlreadyExists").exceptionBuilderSupplier(SnapshotScheduleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleQuotaExceeded").exceptionBuilderSupplier(SnapshotScheduleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionEventIdNotFound").exceptionBuilderSupplier(SubscriptionEventIdNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubscriptionStateFault").exceptionBuilderSupplier(InvalidSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotScheduleState").exceptionBuilderSupplier(InvalidClusterSnapshotScheduleStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterTrack").exceptionBuilderSupplier(InvalidClusterTrackException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionSeverityNotFound").exceptionBuilderSupplier(SubscriptionSeverityNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CopyToRegionDisabledFault").exceptionBuilderSupplier(CopyToRegionDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestore").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(406)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyDisabledFault").exceptionBuilderSupplier(SnapshotCopyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupQuotaExceeded").exceptionBuilderSupplier(ClusterSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSchedule").exceptionBuilderSupplier(InvalidScheduleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceRequestThrottlingFault").exceptionBuilderSupplier(DependentServiceRequestThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketNotFoundFault").exceptionBuilderSupplier(BucketNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededFault").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTableRestoreArgument").exceptionBuilderSupplier(InvalidTableRestoreArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantAlreadyExistsFault").exceptionBuilderSupplier(SnapshotCopyGrantAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantQuotaExceededFault").exceptionBuilderSupplier(SnapshotCopyGrantQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownSnapshotCopyRegionFault").exceptionBuilderSupplier(UnknownSnapshotCopyRegionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableRestoreNotFoundFault").exceptionBuilderSupplier(TableRestoreNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterNotFound").exceptionBuilderSupplier(ClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterQuotaExceeded").exceptionBuilderSupplier(ClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationQuotaExceededFault").exceptionBuilderSupplier(HsmConfigurationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantNotFoundFault").exceptionBuilderSupplier(SnapshotCopyGrantNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyMigrated").exceptionBuilderSupplier(ReservedNodeAlreadyMigratedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateNotFoundFault").exceptionBuilderSupplier(HsmClientCertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyEnabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationAlreadyExistsFault").exceptionBuilderSupplier(HsmConfigurationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterState").exceptionBuilderSupplier(InvalidClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReservedNodeState").exceptionBuilderSupplier(InvalidReservedNodeStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetQuotaExceededFault").exceptionBuilderSupplier(ClusterSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterParameterGroupState").exceptionBuilderSupplier(InvalidClusterParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceUnavailableFault").exceptionBuilderSupplier(DependentServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupNotFoundFault").exceptionBuilderSupplier(ClusterSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyDisabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupNotFound").exceptionBuilderSupplier(ClusterSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotQuotaExceeded").exceptionBuilderSupplier(ClusterSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterAlreadyExists").exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationNotFoundFault").exceptionBuilderSupplier(HsmConfigurationNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesPerClusterLimitExceeded").exceptionBuilderSupplier(NumberOfNodesPerClusterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesQuotaExceeded").exceptionBuilderSupplier(NumberOfNodesQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotAlreadyExists").exceptionBuilderSupplier(ClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRetentionPeriodFault").exceptionBuilderSupplier(InvalidRetentionPeriodException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupAlreadyExists").exceptionBuilderSupplier(ClusterSecurityGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded").exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeOfferingNotFound").exceptionBuilderSupplier(ReservedNodeOfferingNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InProgressTableRestoreQuotaExceededFault").exceptionBuilderSupplier(InProgressTableRestoreQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessToSnapshotDenied").exceptionBuilderSupplier(AccessToSnapshotDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidElasticIpFault").exceptionBuilderSupplier(InvalidElasticIpException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableLimitExceeded").exceptionBuilderSupplier(TableLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleUpdateInProgress").exceptionBuilderSupplier(SnapshotScheduleUpdateInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnapshotCopyGrantStateFault").exceptionBuilderSupplier(InvalidSnapshotCopyGrantStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResizeNotFound").exceptionBuilderSupplier(ResizeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmClientCertificateStateFault").exceptionBuilderSupplier(InvalidHsmClientCertificateStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetGroupStateFault").exceptionBuilderSupplier(InvalidClusterSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterOnLatestRevision").exceptionBuilderSupplier(ClusterOnLatestRevisionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotNotFound").exceptionBuilderSupplier(ClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduleDefinitionTypeUnsupported").exceptionBuilderSupplier(ScheduleDefinitionTypeUnsupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchModifyClusterSnapshotsLimitExceededFault").exceptionBuilderSupplier(BatchModifyClusterSnapshotsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagFault").exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateAlreadyExistsFault").exceptionBuilderSupplier(HsmClientCertificateAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateQuotaExceededFault").exceptionBuilderSupplier(HsmClientCertificateQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSecurityGroupState").exceptionBuilderSupplier(InvalidClusterSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceeded").exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupQuotaExceeded").exceptionBuilderSupplier(ClusterParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperation").exceptionBuilderSupplier(UnauthorizedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetStateFault").exceptionBuilderSupplier(InvalidClusterSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleNotFound").exceptionBuilderSupplier(SnapshotScheduleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExists").exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeNotFound").exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleOrderableOptions").exceptionBuilderSupplier(IncompatibleOrderableOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameFault").exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOptionFault").exceptionBuilderSupplier(UnsupportedOptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacity").exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupAlreadyExists").exceptionBuilderSupplier(ClusterSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededFault").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupNotFound").exceptionBuilderSupplier(ClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceeded.ClusterSecurityGroup").exceptionBuilderSupplier(ClusterSecurityGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists").exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotState").exceptionBuilderSupplier(InvalidClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupAlreadyExists").exceptionBuilderSupplier(ClusterParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyFault").exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchDeleteRequestSizeExceeded").exceptionBuilderSupplier(BatchDeleteRequestSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixFault").exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RedshiftException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RedshiftRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.20").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RedshiftRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

