/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;

public class DescribeReservedNodesPublisher
implements SdkPublisher<DescribeReservedNodesResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodesPublisher(RedshiftAsyncClient client, DescribeReservedNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodesPublisher(RedshiftAsyncClient client, DescribeReservedNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodes() != null) {
                return response.reservedNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedNodesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedNodesPublisher resume(DescribeReservedNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedNodesPublisher(this.client, (DescribeReservedNodesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedNodesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedNodesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedNodesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeReservedNodesResponse> nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesPublisher.this.client.describeReservedNodes(DescribeReservedNodesPublisher.this.firstRequest);
            }
            return DescribeReservedNodesPublisher.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

