/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;

public class DescribeEventSubscriptionsRequestMarshaller
implements Marshaller<Request<DescribeEventSubscriptionsRequest>, DescribeEventSubscriptionsRequest> {
    public Request<DescribeEventSubscriptionsRequest> marshall(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        List<String> tagValuesList;
        List<String> tagKeysList;
        if (describeEventSubscriptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeEventSubscriptionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeEventSubscriptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventSubscriptionsRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)describeEventSubscriptionsRequest.subscriptionName()));
        }
        if (describeEventSubscriptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventSubscriptionsRequest.maxRecords()));
        }
        if (describeEventSubscriptionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeEventSubscriptionsRequest.marker()));
        }
        if ((tagKeysList = describeEventSubscriptionsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        if ((tagValuesList = describeEventSubscriptionsRequest.tagValues()) != null) {
            if (!tagValuesList.isEmpty()) {
                int tagValuesListIndex = 1;
                for (String tagValuesListValue : tagValuesList) {
                    if (tagValuesListValue != null) {
                        request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                    }
                    ++tagValuesListIndex;
                }
            } else {
                request.addParameter("TagValues", "");
            }
        }
        return request;
    }
}

