/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;

public class AuthorizeClusterSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeClusterSecurityGroupIngressRequest>, AuthorizeClusterSecurityGroupIngressRequest> {
    public Request<AuthorizeClusterSecurityGroupIngressRequest> marshall(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        if (authorizeClusterSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)authorizeClusterSecurityGroupIngressRequest, "RedshiftClient");
        request.addParameter("Action", "AuthorizeClusterSecurityGroupIngress");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeClusterSecurityGroupIngressRequest.clusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringUtils.fromString((String)authorizeClusterSecurityGroupIngressRequest.clusterSecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringUtils.fromString((String)authorizeClusterSecurityGroupIngressRequest.cidrip()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringUtils.fromString((String)authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringUtils.fromString((String)authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

