/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;

public final class DescribeOrderableClusterOptionsPaginator
implements SdkIterable<DescribeOrderableClusterOptionsResponse> {
    private final RedshiftClient client;
    private final DescribeOrderableClusterOptionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeOrderableClusterOptionsPaginator(RedshiftClient client, DescribeOrderableClusterOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrderableClusterOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableClusterOptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OrderableClusterOption> orderableClusterOptions() {
        Function<DescribeOrderableClusterOptionsResponse, Iterator> getIterator = response -> response != null ? response.orderableClusterOptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeOrderableClusterOptionsResponseFetcher
    implements NextPageFetcher<DescribeOrderableClusterOptionsResponse> {
        private DescribeOrderableClusterOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOrderableClusterOptionsResponse nextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableClusterOptionsPaginator.this.client.describeOrderableClusterOptions(DescribeOrderableClusterOptionsPaginator.this.firstRequest);
            }
            return DescribeOrderableClusterOptionsPaginator.this.client.describeOrderableClusterOptions((DescribeOrderableClusterOptionsRequest)((Object)DescribeOrderableClusterOptionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

