/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.SourceIdsListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventSubscription
implements ToCopyableBuilder<Builder, EventSubscription> {
    private final String customerAwsId;
    private final String custSubscriptionId;
    private final String snsTopicArn;
    private final String status;
    private final Instant subscriptionCreationTime;
    private final String sourceType;
    private final List<String> sourceIdsList;
    private final List<String> eventCategoriesList;
    private final String severity;
    private final Boolean enabled;
    private final List<Tag> tags;

    private EventSubscription(BuilderImpl builder) {
        this.customerAwsId = builder.customerAwsId;
        this.custSubscriptionId = builder.custSubscriptionId;
        this.snsTopicArn = builder.snsTopicArn;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
        this.sourceType = builder.sourceType;
        this.sourceIdsList = builder.sourceIdsList;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    public String customerAwsId() {
        return this.customerAwsId;
    }

    public String custSubscriptionId() {
        return this.custSubscriptionId;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String status() {
        return this.status;
    }

    public Instant subscriptionCreationTime() {
        return this.subscriptionCreationTime;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> sourceIdsList() {
        return this.sourceIdsList;
    }

    public List<String> eventCategoriesList() {
        return this.eventCategoriesList;
    }

    public String severity() {
        return this.severity;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAwsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.custSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoriesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription)obj;
        return Objects.equals(this.customerAwsId(), other.customerAwsId()) && Objects.equals(this.custSubscriptionId(), other.custSubscriptionId()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.subscriptionCreationTime(), other.subscriptionCreationTime()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.sourceIdsList(), other.sourceIdsList()) && Objects.equals(this.eventCategoriesList(), other.eventCategoriesList()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"EventSubscription").add("CustomerAwsId", (Object)this.customerAwsId()).add("CustSubscriptionId", (Object)this.custSubscriptionId()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("Status", (Object)this.status()).add("SubscriptionCreationTime", (Object)this.subscriptionCreationTime()).add("SourceType", (Object)this.sourceType()).add("SourceIdsList", this.sourceIdsList()).add("EventCategoriesList", this.eventCategoriesList()).add("Severity", (Object)this.severity()).add("Enabled", (Object)this.enabled()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerAwsId": {
                return Optional.of(clazz.cast(this.customerAwsId()));
            }
            case "CustSubscriptionId": {
                return Optional.of(clazz.cast(this.custSubscriptionId()));
            }
            case "SnsTopicArn": {
                return Optional.of(clazz.cast(this.snsTopicArn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "SubscriptionCreationTime": {
                return Optional.of(clazz.cast(this.subscriptionCreationTime()));
            }
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceType()));
            }
            case "SourceIdsList": {
                return Optional.of(clazz.cast(this.sourceIdsList()));
            }
            case "EventCategoriesList": {
                return Optional.of(clazz.cast(this.eventCategoriesList()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severity()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String customerAwsId;
        private String custSubscriptionId;
        private String snsTopicArn;
        private String status;
        private Instant subscriptionCreationTime;
        private String sourceType;
        private List<String> sourceIdsList;
        private List<String> eventCategoriesList;
        private String severity;
        private Boolean enabled;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            this.customerAwsId(model.customerAwsId);
            this.custSubscriptionId(model.custSubscriptionId);
            this.snsTopicArn(model.snsTopicArn);
            this.status(model.status);
            this.subscriptionCreationTime(model.subscriptionCreationTime);
            this.sourceType(model.sourceType);
            this.sourceIdsList(model.sourceIdsList);
            this.eventCategoriesList(model.eventCategoriesList);
            this.severity(model.severity);
            this.enabled(model.enabled);
            this.tags(model.tags);
        }

        public final String getCustomerAwsId() {
            return this.customerAwsId;
        }

        @Override
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        public final String getCustSubscriptionId() {
            return this.custSubscriptionId;
        }

        @Override
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubscriptionCreationTime() {
            return this.subscriptionCreationTime;
        }

        @Override
        public final Builder subscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        public final void setSubscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getSourceIdsList() {
            return this.sourceIdsList;
        }

        @Override
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIdsList(String ... sourceIdsList) {
            this.sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
        }

        public final Collection<String> getEventCategoriesList() {
            return this.eventCategoriesList;
        }

        @Override
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesList(String ... eventCategoriesList) {
            this.eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public EventSubscription build() {
            return new EventSubscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventSubscription> {
        public Builder customerAwsId(String var1);

        public Builder custSubscriptionId(String var1);

        public Builder snsTopicArn(String var1);

        public Builder status(String var1);

        public Builder subscriptionCreationTime(Instant var1);

        public Builder sourceType(String var1);

        public Builder sourceIdsList(Collection<String> var1);

        public Builder sourceIdsList(String ... var1);

        public Builder eventCategoriesList(Collection<String> var1);

        public Builder eventCategoriesList(String ... var1);

        public Builder severity(String var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

