/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.Snapshot;
import software.amazon.awssdk.services.redshift.model.SnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSnapshotsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSnapshotsResponse> {
    private final String marker;
    private final List<Snapshot> snapshots;

    private DescribeClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.snapshots = builder.snapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSnapshotsResponse)) {
            return false;
        }
        DescribeClusterSnapshotsResponse other = (DescribeClusterSnapshotsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.snapshots(), other.snapshots());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClusterSnapshotsResponse").add("Marker", (Object)this.marker()).add("Snapshots", this.snapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Snapshots": {
                return Optional.of(clazz.cast(this.snapshots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Snapshot> snapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSnapshotsResponse model) {
            this.marker(model.marker);
            this.snapshots(model.snapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Snapshot.Builder> getSnapshots() {
            return this.snapshots != null ? (Collection)this.snapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public DescribeClusterSnapshotsResponse build() {
            return new DescribeClusterSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClusterSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder snapshots(Collection<Snapshot> var1);

        public Builder snapshots(Snapshot ... var1);
    }
}

