/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.TaggedResource;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class TaggedResourceUnmarshaller
implements Unmarshaller<TaggedResource, StaxUnmarshallerContext> {
    private static final TaggedResourceUnmarshaller INSTANCE = new TaggedResourceUnmarshaller();

    public TaggedResource unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TaggedResource.Builder taggedResource = TaggedResource.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Tag", targetDepth)) {
                    taggedResource.tag(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceName", targetDepth)) {
                    taggedResource.resourceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceType", targetDepth)) continue;
                taggedResource.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TaggedResource)taggedResource.build();
    }

    public static TaggedResourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

