/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterNode;

public class ClusterNodeUnmarshaller
implements Unmarshaller<ClusterNode, StaxUnmarshallerContext> {
    private static final ClusterNodeUnmarshaller INSTANCE = new ClusterNodeUnmarshaller();

    public ClusterNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ClusterNode.Builder clusterNode = ClusterNode.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeRole", targetDepth)) {
                    clusterNode.nodeRole(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrivateIPAddress", targetDepth)) {
                    clusterNode.privateIPAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PublicIPAddress", targetDepth)) continue;
                clusterNode.publicIPAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ClusterNode)clusterNode.build();
    }

    public static ClusterNodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

