/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;

public class DescribeClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeClusterParametersRequest>, DescribeClusterParametersRequest> {
    public Request<DescribeClusterParametersRequest> marshall(DescribeClusterParametersRequest describeClusterParametersRequest) {
        if (describeClusterParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterParametersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterParameters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterParametersRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)describeClusterParametersRequest.parameterGroupName()));
        }
        if (describeClusterParametersRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeClusterParametersRequest.source()));
        }
        if (describeClusterParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterParametersRequest.maxRecords()));
        }
        if (describeClusterParametersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterParametersRequest.marker()));
        }
        return request;
    }
}

