/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedNodeOfferingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedNodeOfferingsRequest> {
    private final String reservedNodeOfferingId;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedNodeOfferingsRequest(BuilderImpl builder) {
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String reservedNodeOfferingId() {
        return this.reservedNodeOfferingId;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodeOfferingsRequest)) {
            return false;
        }
        DescribeReservedNodeOfferingsRequest other = (DescribeReservedNodeOfferingsRequest)((Object)obj);
        return Objects.equals(this.reservedNodeOfferingId(), other.reservedNodeOfferingId()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservedNodeOfferingId() != null) {
            sb.append("ReservedNodeOfferingId: ").append(this.reservedNodeOfferingId()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeOfferingId": {
                return Optional.of(clazz.cast(this.reservedNodeOfferingId()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedNodeOfferingId;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodeOfferingsRequest model) {
            this.reservedNodeOfferingId(model.reservedNodeOfferingId);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReservedNodeOfferingId() {
            return this.reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeReservedNodeOfferingsRequest build() {
            return new DescribeReservedNodeOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedNodeOfferingsRequest> {
        public Builder reservedNodeOfferingId(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

