/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmClientCertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
    private final String marker;
    private final List<HsmClientCertificate> hsmClientCertificates;

    private DescribeHsmClientCertificatesResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.hsmClientCertificates = builder.hsmClientCertificates;
    }

    public String marker() {
        return this.marker;
    }

    public List<HsmClientCertificate> hsmClientCertificates() {
        return this.hsmClientCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmClientCertificatesResponse)) {
            return false;
        }
        DescribeHsmClientCertificatesResponse other = (DescribeHsmClientCertificatesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hsmClientCertificates(), other.hsmClientCertificates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hsmClientCertificates() != null) {
            sb.append("HsmClientCertificates: ").append(this.hsmClientCertificates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "HsmClientCertificates": {
                return Optional.of(clazz.cast(this.hsmClientCertificates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<HsmClientCertificate> hsmClientCertificates;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmClientCertificatesResponse model) {
            this.marker(model.marker);
            this.hsmClientCertificates(model.hsmClientCertificates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmClientCertificate.Builder> getHsmClientCertificates() {
            return this.hsmClientCertificates != null ? (Collection)this.hsmClientCertificates.stream().map(HsmClientCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copy(hsmClientCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(HsmClientCertificate ... hsmClientCertificates) {
            this.hsmClientCertificates(Arrays.asList(hsmClientCertificates));
            return this;
        }

        public final void setHsmClientCertificates(Collection<HsmClientCertificate.BuilderImpl> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copyFromBuilder(hsmClientCertificates);
        }

        public DescribeHsmClientCertificatesResponse build() {
            return new DescribeHsmClientCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
        public Builder marker(String var1);

        public Builder hsmClientCertificates(Collection<HsmClientCertificate> var1);

        public Builder hsmClientCertificates(HsmClientCertificate ... var1);
    }
}

