/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroup;
import software.amazon.awssdk.services.redshift.model.ParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
    private final String marker;
    private final List<ClusterParameterGroup> parameterGroups;

    private DescribeClusterParameterGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.parameterGroups = builder.parameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterParameterGroup> parameterGroups() {
        return this.parameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeClusterParameterGroupsResponse other = (DescribeClusterParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.parameterGroups(), other.parameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameterGroups() != null) {
            sb.append("ParameterGroups: ").append(this.parameterGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ParameterGroups": {
                return Optional.of(clazz.cast(this.parameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterParameterGroup> parameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterParameterGroupsResponse model) {
            this.marker(model.marker);
            this.parameterGroups(model.parameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterParameterGroup.Builder> getParameterGroups() {
            return this.parameterGroups != null ? (Collection)this.parameterGroups.stream().map(ClusterParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ClusterParameterGroup ... parameterGroups) {
            this.parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        public final void setParameterGroups(Collection<ClusterParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        public DescribeClusterParameterGroupsResponse build() {
            return new DescribeClusterParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder parameterGroups(Collection<ClusterParameterGroup> var1);

        public Builder parameterGroups(ClusterParameterGroup ... var1);
    }
}

