/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;

public class DescribeResizeRequestMarshaller
implements Marshaller<Request<DescribeResizeRequest>, DescribeResizeRequest> {
    public Request<DescribeResizeRequest> marshall(DescribeResizeRequest describeResizeRequest) {
        if (describeResizeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeResizeRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeResize");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeResizeRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeResizeRequest.clusterIdentifier()));
        }
        return request;
    }
}

