/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HsmConfiguration
implements ToCopyableBuilder<Builder, HsmConfiguration> {
    private final String hsmConfigurationIdentifier;
    private final String description;
    private final String hsmIpAddress;
    private final String hsmPartitionName;
    private final List<Tag> tags;

    private HsmConfiguration(BuilderImpl builder) {
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.description = builder.description;
        this.hsmIpAddress = builder.hsmIpAddress;
        this.hsmPartitionName = builder.hsmPartitionName;
        this.tags = builder.tags;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String description() {
        return this.description;
    }

    public String hsmIpAddress() {
        return this.hsmIpAddress;
    }

    public String hsmPartitionName() {
        return this.hsmPartitionName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hsmConfigurationIdentifier() == null ? 0 : this.hsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.hsmIpAddress() == null ? 0 : this.hsmIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.hsmPartitionName() == null ? 0 : this.hsmPartitionName().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmConfiguration)) {
            return false;
        }
        HsmConfiguration other = (HsmConfiguration)obj;
        if (other.hsmConfigurationIdentifier() == null ^ this.hsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() != null && !other.hsmConfigurationIdentifier().equals(this.hsmConfigurationIdentifier())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.hsmIpAddress() == null ^ this.hsmIpAddress() == null) {
            return false;
        }
        if (other.hsmIpAddress() != null && !other.hsmIpAddress().equals(this.hsmIpAddress())) {
            return false;
        }
        if (other.hsmPartitionName() == null ^ this.hsmPartitionName() == null) {
            return false;
        }
        if (other.hsmPartitionName() != null && !other.hsmPartitionName().equals(this.hsmPartitionName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.hsmConfigurationIdentifier()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.hsmIpAddress() != null) {
            sb.append("HsmIpAddress: ").append(this.hsmIpAddress()).append(",");
        }
        if (this.hsmPartitionName() != null) {
            sb.append("HsmPartitionName: ").append(this.hsmPartitionName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmConfigurationIdentifier": {
                return Optional.of(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "HsmIpAddress": {
                return Optional.of(clazz.cast(this.hsmIpAddress()));
            }
            case "HsmPartitionName": {
                return Optional.of(clazz.cast(this.hsmPartitionName()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmConfigurationIdentifier;
        private String description;
        private String hsmIpAddress;
        private String hsmPartitionName;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmConfiguration model) {
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.description(model.description);
            this.hsmIpAddress(model.hsmIpAddress);
            this.hsmPartitionName(model.hsmPartitionName);
            this.tags(model.tags);
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHsmIpAddress() {
            return this.hsmIpAddress;
        }

        @Override
        public final Builder hsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
            return this;
        }

        public final void setHsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
        }

        public final String getHsmPartitionName() {
            return this.hsmPartitionName;
        }

        @Override
        public final Builder hsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
            return this;
        }

        public final void setHsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public HsmConfiguration build() {
            return new HsmConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HsmConfiguration> {
        public Builder hsmConfigurationIdentifier(String var1);

        public Builder description(String var1);

        public Builder hsmIpAddress(String var1);

        public Builder hsmPartitionName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

