/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateClusterSnapshotRequest> {
    private final String snapshotIdentifier;
    private final String clusterIdentifier;
    private final List<Tag> tags;

    private CreateClusterSnapshotRequest(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.tags = builder.tags;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSnapshotRequest)) {
            return false;
        }
        CreateClusterSnapshotRequest other = (CreateClusterSnapshotRequest)((Object)obj);
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String clusterIdentifier;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSnapshotRequest model) {
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.clusterIdentifier(model.clusterIdentifier);
            this.tags(model.tags);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CreateClusterSnapshotRequest build() {
            return new CreateClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateClusterSnapshotRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

