/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.Event;

public class EventUnmarshaller
implements Unmarshaller<Event, StaxUnmarshallerContext> {
    private static final EventUnmarshaller INSTANCE = new EventUnmarshaller();

    public Event unmarshall(StaxUnmarshallerContext context) throws Exception {
        Event.Builder event;
        block11: {
            event = Event.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> eventCategories = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    event.eventCategories(eventCategories);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SourceIdentifier", targetDepth)) {
                        event.sourceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceType", targetDepth)) {
                        event.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Message", targetDepth)) {
                        event.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EventCategories", targetDepth)) {
                        eventCategories = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("EventCategories/EventCategory", targetDepth)) {
                        eventCategories.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Severity", targetDepth)) {
                        event.severity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Date", targetDepth)) {
                        event.date(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EventId", targetDepth)) continue;
                    event.eventId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            event.eventCategories(eventCategories);
        }
        return (Event)event.build();
    }

    public static EventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

