/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevokeSnapshotAccessRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RevokeSnapshotAccessRequest> {
    private final String snapshotIdentifier;
    private final String snapshotClusterIdentifier;
    private final String accountWithRestoreAccess;

    private RevokeSnapshotAccessRequest(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.accountWithRestoreAccess = builder.accountWithRestoreAccess;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public String accountWithRestoreAccess() {
        return this.accountWithRestoreAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotClusterIdentifier() == null ? 0 : this.snapshotClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.accountWithRestoreAccess() == null ? 0 : this.accountWithRestoreAccess().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSnapshotAccessRequest)) {
            return false;
        }
        RevokeSnapshotAccessRequest other = (RevokeSnapshotAccessRequest)((Object)obj);
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.snapshotClusterIdentifier() == null ^ this.snapshotClusterIdentifier() == null) {
            return false;
        }
        if (other.snapshotClusterIdentifier() != null && !other.snapshotClusterIdentifier().equals(this.snapshotClusterIdentifier())) {
            return false;
        }
        if (other.accountWithRestoreAccess() == null ^ this.accountWithRestoreAccess() == null) {
            return false;
        }
        return other.accountWithRestoreAccess() == null || other.accountWithRestoreAccess().equals(this.accountWithRestoreAccess());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.snapshotClusterIdentifier() != null) {
            sb.append("SnapshotClusterIdentifier: ").append(this.snapshotClusterIdentifier()).append(",");
        }
        if (this.accountWithRestoreAccess() != null) {
            sb.append("AccountWithRestoreAccess: ").append(this.accountWithRestoreAccess()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String snapshotClusterIdentifier;
        private String accountWithRestoreAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSnapshotAccessRequest model) {
            this.setSnapshotIdentifier(model.snapshotIdentifier);
            this.setSnapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.setAccountWithRestoreAccess(model.accountWithRestoreAccess);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final String getAccountWithRestoreAccess() {
            return this.accountWithRestoreAccess;
        }

        @Override
        public final Builder accountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
            return this;
        }

        public final void setAccountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
        }

        public RevokeSnapshotAccessRequest build() {
            return new RevokeSnapshotAccessRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevokeSnapshotAccessRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder accountWithRestoreAccess(String var1);
    }
}

