/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class HsmConfigurationUnmarshaller
implements Unmarshaller<HsmConfiguration, StaxUnmarshallerContext> {
    private static HsmConfigurationUnmarshaller INSTANCE;

    public HsmConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        HsmConfiguration.Builder hsmConfiguration;
        block9: {
            hsmConfiguration = HsmConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    hsmConfiguration.tags(tags);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("HsmConfigurationIdentifier", targetDepth)) {
                        hsmConfiguration.hsmConfigurationIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        hsmConfiguration.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HsmIpAddress", targetDepth)) {
                        hsmConfiguration.hsmIpAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HsmPartitionName", targetDepth)) {
                        hsmConfiguration.hsmPartitionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            hsmConfiguration.tags(tags);
        }
        return (HsmConfiguration)hsmConfiguration.build();
    }

    public static HsmConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HsmConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

