/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ImportTablesCompletedCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesInProgressCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesNotStartedCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResizeResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeResizeResponse> {
    private static final SdkField<String> TARGET_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResizeResponse.getter(DescribeResizeResponse::targetNodeType)).setter(DescribeResizeResponse.setter(Builder::targetNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNodeType").build()}).build();
    private static final SdkField<Integer> TARGET_NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeResizeResponse.getter(DescribeResizeResponse::targetNumberOfNodes)).setter(DescribeResizeResponse.setter(Builder::targetNumberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNumberOfNodes").build()}).build();
    private static final SdkField<String> TARGET_CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResizeResponse.getter(DescribeResizeResponse::targetClusterType)).setter(DescribeResizeResponse.setter(Builder::targetClusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetClusterType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResizeResponse.getter(DescribeResizeResponse::status)).setter(DescribeResizeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeResizeResponse.getter(DescribeResizeResponse::importTablesCompleted)).setter(DescribeResizeResponse.setter(Builder::importTablesCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesCompleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeResizeResponse.getter(DescribeResizeResponse::importTablesInProgress)).setter(DescribeResizeResponse.setter(Builder::importTablesInProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesInProgress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_NOT_STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeResizeResponse.getter(DescribeResizeResponse::importTablesNotStarted)).setter(DescribeResizeResponse.setter(Builder::importTablesNotStarted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesNotStarted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DescribeResizeResponse.getter(DescribeResizeResponse::avgResizeRateInMegaBytesPerSecond)).setter(DescribeResizeResponse.setter(Builder::avgResizeRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvgResizeRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeResizeResponse.getter(DescribeResizeResponse::totalResizeDataInMegaBytes)).setter(DescribeResizeResponse.setter(Builder::totalResizeDataInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResizeDataInMegaBytes").build()}).build();
    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeResizeResponse.getter(DescribeResizeResponse::progressInMegaBytes)).setter(DescribeResizeResponse.setter(Builder::progressInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeResizeResponse.getter(DescribeResizeResponse::elapsedTimeInSeconds)).setter(DescribeResizeResponse.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeResizeResponse.getter(DescribeResizeResponse::estimatedTimeToCompletionInSeconds)).setter(DescribeResizeResponse.setter(Builder::estimatedTimeToCompletionInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds").build()}).build();
    private static final SdkField<String> RESIZE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResizeResponse.getter(DescribeResizeResponse::resizeType)).setter(DescribeResizeResponse.setter(Builder::resizeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResizeResponse.getter(DescribeResizeResponse::message)).setter(DescribeResizeResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODE_TYPE_FIELD, TARGET_NUMBER_OF_NODES_FIELD, TARGET_CLUSTER_TYPE_FIELD, STATUS_FIELD, IMPORT_TABLES_COMPLETED_FIELD, IMPORT_TABLES_IN_PROGRESS_FIELD, IMPORT_TABLES_NOT_STARTED_FIELD, AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, RESIZE_TYPE_FIELD, MESSAGE_FIELD));
    private final String targetNodeType;
    private final Integer targetNumberOfNodes;
    private final String targetClusterType;
    private final String status;
    private final List<String> importTablesCompleted;
    private final List<String> importTablesInProgress;
    private final List<String> importTablesNotStarted;
    private final Double avgResizeRateInMegaBytesPerSecond;
    private final Long totalResizeDataInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;
    private final String resizeType;
    private final String message;

    private DescribeResizeResponse(BuilderImpl builder) {
        super(builder);
        this.targetNodeType = builder.targetNodeType;
        this.targetNumberOfNodes = builder.targetNumberOfNodes;
        this.targetClusterType = builder.targetClusterType;
        this.status = builder.status;
        this.importTablesCompleted = builder.importTablesCompleted;
        this.importTablesInProgress = builder.importTablesInProgress;
        this.importTablesNotStarted = builder.importTablesNotStarted;
        this.avgResizeRateInMegaBytesPerSecond = builder.avgResizeRateInMegaBytesPerSecond;
        this.totalResizeDataInMegaBytes = builder.totalResizeDataInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.resizeType = builder.resizeType;
        this.message = builder.message;
    }

    public String targetNodeType() {
        return this.targetNodeType;
    }

    public Integer targetNumberOfNodes() {
        return this.targetNumberOfNodes;
    }

    public String targetClusterType() {
        return this.targetClusterType;
    }

    public String status() {
        return this.status;
    }

    public List<String> importTablesCompleted() {
        return this.importTablesCompleted;
    }

    public List<String> importTablesInProgress() {
        return this.importTablesInProgress;
    }

    public List<String> importTablesNotStarted() {
        return this.importTablesNotStarted;
    }

    public Double avgResizeRateInMegaBytesPerSecond() {
        return this.avgResizeRateInMegaBytesPerSecond;
    }

    public Long totalResizeDataInMegaBytes() {
        return this.totalResizeDataInMegaBytes;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public String resizeType() {
        return this.resizeType;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNumberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTablesCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTablesInProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTablesNotStarted());
        hashCode = 31 * hashCode + Objects.hashCode(this.avgResizeRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResizeDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.resizeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResizeResponse)) {
            return false;
        }
        DescribeResizeResponse other = (DescribeResizeResponse)((Object)obj);
        return Objects.equals(this.targetNodeType(), other.targetNodeType()) && Objects.equals(this.targetNumberOfNodes(), other.targetNumberOfNodes()) && Objects.equals(this.targetClusterType(), other.targetClusterType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.importTablesCompleted(), other.importTablesCompleted()) && Objects.equals(this.importTablesInProgress(), other.importTablesInProgress()) && Objects.equals(this.importTablesNotStarted(), other.importTablesNotStarted()) && Objects.equals(this.avgResizeRateInMegaBytesPerSecond(), other.avgResizeRateInMegaBytesPerSecond()) && Objects.equals(this.totalResizeDataInMegaBytes(), other.totalResizeDataInMegaBytes()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds()) && Objects.equals(this.resizeType(), other.resizeType()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResizeResponse").add("TargetNodeType", (Object)this.targetNodeType()).add("TargetNumberOfNodes", (Object)this.targetNumberOfNodes()).add("TargetClusterType", (Object)this.targetClusterType()).add("Status", (Object)this.status()).add("ImportTablesCompleted", this.importTablesCompleted()).add("ImportTablesInProgress", this.importTablesInProgress()).add("ImportTablesNotStarted", this.importTablesNotStarted()).add("AvgResizeRateInMegaBytesPerSecond", (Object)this.avgResizeRateInMegaBytesPerSecond()).add("TotalResizeDataInMegaBytes", (Object)this.totalResizeDataInMegaBytes()).add("ProgressInMegaBytes", (Object)this.progressInMegaBytes()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("EstimatedTimeToCompletionInSeconds", (Object)this.estimatedTimeToCompletionInSeconds()).add("ResizeType", (Object)this.resizeType()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetNodeType": {
                return Optional.ofNullable(clazz.cast(this.targetNodeType()));
            }
            case "TargetNumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNumberOfNodes()));
            }
            case "TargetClusterType": {
                return Optional.ofNullable(clazz.cast(this.targetClusterType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ImportTablesCompleted": {
                return Optional.ofNullable(clazz.cast(this.importTablesCompleted()));
            }
            case "ImportTablesInProgress": {
                return Optional.ofNullable(clazz.cast(this.importTablesInProgress()));
            }
            case "ImportTablesNotStarted": {
                return Optional.ofNullable(clazz.cast(this.importTablesNotStarted()));
            }
            case "AvgResizeRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.avgResizeRateInMegaBytesPerSecond()));
            }
            case "TotalResizeDataInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalResizeDataInMegaBytes()));
            }
            case "ProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.progressInMegaBytes()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
            case "ResizeType": {
                return Optional.ofNullable(clazz.cast(this.resizeType()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResizeResponse, T> g) {
        return obj -> g.apply((DescribeResizeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String targetNodeType;
        private Integer targetNumberOfNodes;
        private String targetClusterType;
        private String status;
        private List<String> importTablesCompleted = DefaultSdkAutoConstructList.getInstance();
        private List<String> importTablesInProgress = DefaultSdkAutoConstructList.getInstance();
        private List<String> importTablesNotStarted = DefaultSdkAutoConstructList.getInstance();
        private Double avgResizeRateInMegaBytesPerSecond;
        private Long totalResizeDataInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;
        private String resizeType;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResizeResponse model) {
            super(model);
            this.targetNodeType(model.targetNodeType);
            this.targetNumberOfNodes(model.targetNumberOfNodes);
            this.targetClusterType(model.targetClusterType);
            this.status(model.status);
            this.importTablesCompleted(model.importTablesCompleted);
            this.importTablesInProgress(model.importTablesInProgress);
            this.importTablesNotStarted(model.importTablesNotStarted);
            this.avgResizeRateInMegaBytesPerSecond(model.avgResizeRateInMegaBytesPerSecond);
            this.totalResizeDataInMegaBytes(model.totalResizeDataInMegaBytes);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            this.resizeType(model.resizeType);
            this.message(model.message);
        }

        public final String getTargetNodeType() {
            return this.targetNodeType;
        }

        @Override
        public final Builder targetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
            return this;
        }

        public final void setTargetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
        }

        public final Integer getTargetNumberOfNodes() {
            return this.targetNumberOfNodes;
        }

        @Override
        public final Builder targetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
            return this;
        }

        public final void setTargetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
        }

        public final String getTargetClusterType() {
            return this.targetClusterType;
        }

        @Override
        public final Builder targetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
            return this;
        }

        public final void setTargetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getImportTablesCompleted() {
            return this.importTablesCompleted;
        }

        @Override
        public final Builder importTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesCompleted(String ... importTablesCompleted) {
            this.importTablesCompleted(Arrays.asList(importTablesCompleted));
            return this;
        }

        public final void setImportTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
        }

        public final Collection<String> getImportTablesInProgress() {
            return this.importTablesInProgress;
        }

        @Override
        public final Builder importTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesInProgress(String ... importTablesInProgress) {
            this.importTablesInProgress(Arrays.asList(importTablesInProgress));
            return this;
        }

        public final void setImportTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
        }

        public final Collection<String> getImportTablesNotStarted() {
            return this.importTablesNotStarted;
        }

        @Override
        public final Builder importTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesNotStarted(String ... importTablesNotStarted) {
            this.importTablesNotStarted(Arrays.asList(importTablesNotStarted));
            return this;
        }

        public final void setImportTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
        }

        public final Double getAvgResizeRateInMegaBytesPerSecond() {
            return this.avgResizeRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder avgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
            return this;
        }

        public final void setAvgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
        }

        public final Long getTotalResizeDataInMegaBytes() {
            return this.totalResizeDataInMegaBytes;
        }

        @Override
        public final Builder totalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
            return this;
        }

        public final void setTotalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public final String getResizeType() {
            return this.resizeType;
        }

        @Override
        public final Builder resizeType(String resizeType) {
            this.resizeType = resizeType;
            return this;
        }

        public final void setResizeType(String resizeType) {
            this.resizeType = resizeType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public DescribeResizeResponse build() {
            return new DescribeResizeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResizeResponse> {
        public Builder targetNodeType(String var1);

        public Builder targetNumberOfNodes(Integer var1);

        public Builder targetClusterType(String var1);

        public Builder status(String var1);

        public Builder importTablesCompleted(Collection<String> var1);

        public Builder importTablesCompleted(String ... var1);

        public Builder importTablesInProgress(Collection<String> var1);

        public Builder importTablesInProgress(String ... var1);

        public Builder importTablesNotStarted(Collection<String> var1);

        public Builder importTablesNotStarted(String ... var1);

        public Builder avgResizeRateInMegaBytesPerSecond(Double var1);

        public Builder totalResizeDataInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);

        public Builder resizeType(String var1);

        public Builder message(String var1);
    }
}

