/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;

public class RevokeSnapshotAccessRequestMarshaller
implements Marshaller<Request<RevokeSnapshotAccessRequest>, RevokeSnapshotAccessRequest> {
    public Request<RevokeSnapshotAccessRequest> marshall(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        if (revokeSnapshotAccessRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)revokeSnapshotAccessRequest, "RedshiftClient");
        request.addParameter("Action", "RevokeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSnapshotAccessRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)revokeSnapshotAccessRequest.snapshotIdentifier()));
        }
        if (revokeSnapshotAccessRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringConversion.fromString((String)revokeSnapshotAccessRequest.snapshotClusterIdentifier()));
        }
        if (revokeSnapshotAccessRequest.accountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringConversion.fromString((String)revokeSnapshotAccessRequest.accountWithRestoreAccess()));
        }
        return request;
    }
}

