/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;

public class DescribeSnapshotCopyGrantsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotCopyGrantsRequest>, DescribeSnapshotCopyGrantsRequest> {
    public Request<DescribeSnapshotCopyGrantsRequest> marshall(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        if (describeSnapshotCopyGrantsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSnapshotCopyGrantsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeSnapshotCopyGrants");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotCopyGrantsRequest.snapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringConversion.fromString((String)describeSnapshotCopyGrantsRequest.snapshotCopyGrantName()));
        }
        if (describeSnapshotCopyGrantsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeSnapshotCopyGrantsRequest.maxRecords()));
        }
        if (describeSnapshotCopyGrantsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeSnapshotCopyGrantsRequest.marker()));
        }
        if (describeSnapshotCopyGrantsRequest.tagKeys().isEmpty() && !(describeSnapshotCopyGrantsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeSnapshotCopyGrantsRequest.tagKeys().isEmpty() && !(describeSnapshotCopyGrantsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeSnapshotCopyGrantsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeSnapshotCopyGrantsRequest.tagValues().isEmpty() && !(describeSnapshotCopyGrantsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeSnapshotCopyGrantsRequest.tagValues().isEmpty() && !(describeSnapshotCopyGrantsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeSnapshotCopyGrantsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

