/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEventsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringConversion.fromString((String)describeEventsRequest.sourceIdentifier()));
        }
        if (describeEventsRequest.sourceTypeAsString() != null) {
            request.addParameter("SourceType", StringConversion.fromString((String)describeEventsRequest.sourceTypeAsString()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.duration() != null) {
            request.addParameter("Duration", StringConversion.fromInteger((Integer)describeEventsRequest.duration()));
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeEventsRequest.marker()));
        }
        return request;
    }
}

