/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CreateClusterParameterGroupRequest>, CreateClusterParameterGroupRequest> {
    public Request<CreateClusterParameterGroupRequest> marshall(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        if (createClusterParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterParameterGroupRequest, "RedshiftClient");
        request.addParameter("Action", "CreateClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterParameterGroupRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringConversion.fromString((String)createClusterParameterGroupRequest.parameterGroupName()));
        }
        if (createClusterParameterGroupRequest.parameterGroupFamily() != null) {
            request.addParameter("ParameterGroupFamily", StringConversion.fromString((String)createClusterParameterGroupRequest.parameterGroupFamily()));
        }
        if (createClusterParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createClusterParameterGroupRequest.description()));
        }
        if (createClusterParameterGroupRequest.tags().isEmpty() && !(createClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createClusterParameterGroupRequest.tags().isEmpty() && !(createClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createClusterParameterGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

