/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevisionTarget
implements ToCopyableBuilder<Builder, RevisionTarget> {
    private final String databaseRevision;
    private final String description;
    private final Instant databaseRevisionReleaseDate;

    private RevisionTarget(BuilderImpl builder) {
        this.databaseRevision = builder.databaseRevision;
        this.description = builder.description;
        this.databaseRevisionReleaseDate = builder.databaseRevisionReleaseDate;
    }

    public String databaseRevision() {
        return this.databaseRevision;
    }

    public String description() {
        return this.description;
    }

    public Instant databaseRevisionReleaseDate() {
        return this.databaseRevisionReleaseDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseRevisionReleaseDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionTarget)) {
            return false;
        }
        RevisionTarget other = (RevisionTarget)obj;
        return Objects.equals(this.databaseRevision(), other.databaseRevision()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.databaseRevisionReleaseDate(), other.databaseRevisionReleaseDate());
    }

    public String toString() {
        return ToString.builder((String)"RevisionTarget").add("DatabaseRevision", (Object)this.databaseRevision()).add("Description", (Object)this.description()).add("DatabaseRevisionReleaseDate", (Object)this.databaseRevisionReleaseDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseRevision": {
                return Optional.ofNullable(clazz.cast(this.databaseRevision()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DatabaseRevisionReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.databaseRevisionReleaseDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseRevision;
        private String description;
        private Instant databaseRevisionReleaseDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionTarget model) {
            this.databaseRevision(model.databaseRevision);
            this.description(model.description);
            this.databaseRevisionReleaseDate(model.databaseRevisionReleaseDate);
        }

        public final String getDatabaseRevision() {
            return this.databaseRevision;
        }

        @Override
        public final Builder databaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
            return this;
        }

        public final void setDatabaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getDatabaseRevisionReleaseDate() {
            return this.databaseRevisionReleaseDate;
        }

        @Override
        public final Builder databaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
            return this;
        }

        public final void setDatabaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
        }

        public RevisionTarget build() {
            return new RevisionTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevisionTarget> {
        public Builder databaseRevision(String var1);

        public Builder description(String var1);

        public Builder databaseRevisionReleaseDate(Instant var1);
    }
}

