/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HsmStatus
implements ToCopyableBuilder<Builder, HsmStatus> {
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String status;

    private HsmStatus(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.status = builder.status;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmStatus)) {
            return false;
        }
        HsmStatus other = (HsmStatus)obj;
        return Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"HsmStatus").add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmStatus model) {
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.status(model.status);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public HsmStatus build() {
            return new HsmStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HsmStatus> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder status(String var1);
    }
}

