/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservedNodeExchangeOfferingsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, GetReservedNodeExchangeOfferingsResponse> {
    private final String marker;
    private final List<ReservedNodeOffering> reservedNodeOfferings;

    private GetReservedNodeExchangeOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodeOfferings = builder.reservedNodeOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedNodeOffering> reservedNodeOfferings() {
        return this.reservedNodeOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedNodeExchangeOfferingsResponse)) {
            return false;
        }
        GetReservedNodeExchangeOfferingsResponse other = (GetReservedNodeExchangeOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedNodeOfferings(), other.reservedNodeOfferings());
    }

    public String toString() {
        return ToString.builder((String)"GetReservedNodeExchangeOfferingsResponse").add("Marker", (Object)this.marker()).add("ReservedNodeOfferings", this.reservedNodeOfferings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedNodeOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNodeOffering> reservedNodeOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedNodeExchangeOfferingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedNodeOfferings(model.reservedNodeOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNodeOffering.Builder> getReservedNodeOfferings() {
            return this.reservedNodeOfferings != null ? (Collection)this.reservedNodeOfferings.stream().map(ReservedNodeOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedNodeOfferings(Collection<ReservedNodeOffering> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copy(reservedNodeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(ReservedNodeOffering ... reservedNodeOfferings) {
            this.reservedNodeOfferings(Arrays.asList(reservedNodeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder> ... reservedNodeOfferings) {
            this.reservedNodeOfferings(Stream.of(reservedNodeOfferings).map(c -> (ReservedNodeOffering)((ReservedNodeOffering.Builder)ReservedNodeOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedNodeOfferings(Collection<ReservedNodeOffering.BuilderImpl> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copyFromBuilder(reservedNodeOfferings);
        }

        @Override
        public GetReservedNodeExchangeOfferingsResponse build() {
            return new GetReservedNodeExchangeOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, GetReservedNodeExchangeOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedNodeOfferings(Collection<ReservedNodeOffering> var1);

        public Builder reservedNodeOfferings(ReservedNodeOffering ... var1);

        public Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder> ... var1);
    }
}

