/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevision;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevisionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterDbRevisionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
    private final String marker;
    private final List<ClusterDbRevision> clusterDbRevisions;

    private DescribeClusterDbRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterDbRevisions = builder.clusterDbRevisions;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterDbRevision> clusterDbRevisions() {
        return this.clusterDbRevisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDbRevisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterDbRevisionsResponse)) {
            return false;
        }
        DescribeClusterDbRevisionsResponse other = (DescribeClusterDbRevisionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.clusterDbRevisions(), other.clusterDbRevisions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClusterDbRevisionsResponse").add("Marker", (Object)this.marker()).add("ClusterDbRevisions", this.clusterDbRevisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ClusterDbRevisions": {
                return Optional.ofNullable(clazz.cast(this.clusterDbRevisions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterDbRevision> clusterDbRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterDbRevisionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterDbRevisions(model.clusterDbRevisions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterDbRevision.Builder> getClusterDbRevisions() {
            return this.clusterDbRevisions != null ? (Collection)this.clusterDbRevisions.stream().map(ClusterDbRevision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copy(clusterDbRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(ClusterDbRevision ... clusterDbRevisions) {
            this.clusterDbRevisions(Arrays.asList(clusterDbRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder> ... clusterDbRevisions) {
            this.clusterDbRevisions(Stream.of(clusterDbRevisions).map(c -> (ClusterDbRevision)((ClusterDbRevision.Builder)ClusterDbRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterDbRevisions(Collection<ClusterDbRevision.BuilderImpl> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copyFromBuilder(clusterDbRevisions);
        }

        @Override
        public DescribeClusterDbRevisionsResponse build() {
            return new DescribeClusterDbRevisionsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
        public Builder marker(String var1);

        public Builder clusterDbRevisions(Collection<ClusterDbRevision> var1);

        public Builder clusterDbRevisions(ClusterDbRevision ... var1);

        public Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder> ... var1);
    }
}

