/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.Parameter;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;

public class ResetClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ResetClusterParameterGroupRequest>, ResetClusterParameterGroupRequest> {
    public Request<ResetClusterParameterGroupRequest> marshall(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) {
        if (resetClusterParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetClusterParameterGroupRequest, "RedshiftClient");
        request.addParameter("Action", "ResetClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetClusterParameterGroupRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringConversion.fromString((String)resetClusterParameterGroupRequest.parameterGroupName()));
        }
        if (resetClusterParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringConversion.fromBoolean((Boolean)resetClusterParameterGroupRequest.resetAllParameters()));
        }
        if (resetClusterParameterGroupRequest.parameters().isEmpty() && !(resetClusterParameterGroupRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!resetClusterParameterGroupRequest.parameters().isEmpty() && !(resetClusterParameterGroupRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = resetClusterParameterGroupRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterName() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringConversion.fromString((String)parametersListValue.parameterName()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.description() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringConversion.fromString((String)parametersListValue.description()));
                }
                if (parametersListValue.source() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringConversion.fromString((String)parametersListValue.source()));
                }
                if (parametersListValue.dataType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringConversion.fromString((String)parametersListValue.dataType()));
                }
                if (parametersListValue.allowedValues() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringConversion.fromString((String)parametersListValue.allowedValues()));
                }
                if (parametersListValue.applyTypeAsString() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringConversion.fromString((String)parametersListValue.applyTypeAsString()));
                }
                if (parametersListValue.isModifiable() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringConversion.fromBoolean((Boolean)parametersListValue.isModifiable()));
                }
                if (parametersListValue.minimumEngineVersion() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringConversion.fromString((String)parametersListValue.minimumEngineVersion()));
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

