/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;

public class ModifyClusterRequestMarshaller
implements Marshaller<Request<ModifyClusterRequest>, ModifyClusterRequest> {
    public Request<ModifyClusterRequest> marshall(ModifyClusterRequest modifyClusterRequest) {
        if (modifyClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)modifyClusterRequest.clusterIdentifier()));
        }
        if (modifyClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringConversion.fromString((String)modifyClusterRequest.clusterType()));
        }
        if (modifyClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringConversion.fromString((String)modifyClusterRequest.nodeType()));
        }
        if (modifyClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringConversion.fromInteger((Integer)modifyClusterRequest.numberOfNodes()));
        }
        if (modifyClusterRequest.clusterSecurityGroups().isEmpty() && !(modifyClusterRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("ClusterSecurityGroups", "");
        } else if (!modifyClusterRequest.clusterSecurityGroups().isEmpty() && !(modifyClusterRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> clusterSecurityGroupsList = modifyClusterRequest.clusterSecurityGroups();
            int clusterSecurityGroupsListIndex = 1;
            for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringConversion.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (modifyClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!modifyClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = modifyClusterRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)modifyClusterRequest.masterUserPassword()));
        }
        if (modifyClusterRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringConversion.fromString((String)modifyClusterRequest.clusterParameterGroupName()));
        }
        if (modifyClusterRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringConversion.fromInteger((Integer)modifyClusterRequest.automatedSnapshotRetentionPeriod()));
        }
        if (modifyClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyClusterRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringConversion.fromString((String)modifyClusterRequest.clusterVersion()));
        }
        if (modifyClusterRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringConversion.fromBoolean((Boolean)modifyClusterRequest.allowVersionUpgrade()));
        }
        if (modifyClusterRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringConversion.fromString((String)modifyClusterRequest.hsmClientCertificateIdentifier()));
        }
        if (modifyClusterRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)modifyClusterRequest.hsmConfigurationIdentifier()));
        }
        if (modifyClusterRequest.newClusterIdentifier() != null) {
            request.addParameter("NewClusterIdentifier", StringConversion.fromString((String)modifyClusterRequest.newClusterIdentifier()));
        }
        if (modifyClusterRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)modifyClusterRequest.publiclyAccessible()));
        }
        if (modifyClusterRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringConversion.fromString((String)modifyClusterRequest.elasticIp()));
        }
        if (modifyClusterRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringConversion.fromBoolean((Boolean)modifyClusterRequest.enhancedVpcRouting()));
        }
        return request;
    }
}

