/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;

public class ModifyClusterIamRolesRequestMarshaller
implements Marshaller<Request<ModifyClusterIamRolesRequest>, ModifyClusterIamRolesRequest> {
    public Request<ModifyClusterIamRolesRequest> marshall(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        if (modifyClusterIamRolesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterIamRolesRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterIamRoles");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterIamRolesRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)modifyClusterIamRolesRequest.clusterIdentifier()));
        }
        if (modifyClusterIamRolesRequest.addIamRoles().isEmpty() && !(modifyClusterIamRolesRequest.addIamRoles() instanceof SdkAutoConstructList)) {
            request.addParameter("AddIamRoles", "");
        } else if (!modifyClusterIamRolesRequest.addIamRoles().isEmpty() && !(modifyClusterIamRolesRequest.addIamRoles() instanceof SdkAutoConstructList)) {
            List<String> addIamRolesList = modifyClusterIamRolesRequest.addIamRoles();
            int addIamRolesListIndex = 1;
            for (String addIamRolesListValue : addIamRolesList) {
                if (addIamRolesListValue != null) {
                    request.addParameter("AddIamRoles.IamRoleArn." + addIamRolesListIndex, StringConversion.fromString((String)addIamRolesListValue));
                }
                ++addIamRolesListIndex;
            }
        }
        if (modifyClusterIamRolesRequest.removeIamRoles().isEmpty() && !(modifyClusterIamRolesRequest.removeIamRoles() instanceof SdkAutoConstructList)) {
            request.addParameter("RemoveIamRoles", "");
        } else if (!modifyClusterIamRolesRequest.removeIamRoles().isEmpty() && !(modifyClusterIamRolesRequest.removeIamRoles() instanceof SdkAutoConstructList)) {
            List<String> removeIamRolesList = modifyClusterIamRolesRequest.removeIamRoles();
            int removeIamRolesListIndex = 1;
            for (String removeIamRolesListValue : removeIamRolesList) {
                if (removeIamRolesListValue != null) {
                    request.addParameter("RemoveIamRoles.IamRoleArn." + removeIamRolesListIndex, StringConversion.fromString((String)removeIamRolesListValue));
                }
                ++removeIamRolesListIndex;
            }
        }
        return request;
    }
}

