/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;

public class EnableSnapshotCopyRequestMarshaller
implements Marshaller<Request<EnableSnapshotCopyRequest>, EnableSnapshotCopyRequest> {
    public Request<EnableSnapshotCopyRequest> marshall(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        if (enableSnapshotCopyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableSnapshotCopyRequest, "RedshiftClient");
        request.addParameter("Action", "EnableSnapshotCopy");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableSnapshotCopyRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)enableSnapshotCopyRequest.clusterIdentifier()));
        }
        if (enableSnapshotCopyRequest.destinationRegion() != null) {
            request.addParameter("DestinationRegion", StringConversion.fromString((String)enableSnapshotCopyRequest.destinationRegion()));
        }
        if (enableSnapshotCopyRequest.retentionPeriod() != null) {
            request.addParameter("RetentionPeriod", StringConversion.fromInteger((Integer)enableSnapshotCopyRequest.retentionPeriod()));
        }
        if (enableSnapshotCopyRequest.snapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringConversion.fromString((String)enableSnapshotCopyRequest.snapshotCopyGrantName()));
        }
        return request;
    }
}

