/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;

public class DescribeClustersRequestMarshaller
implements Marshaller<Request<DescribeClustersRequest>, DescribeClustersRequest> {
    public Request<DescribeClustersRequest> marshall(DescribeClustersRequest describeClustersRequest) {
        if (describeClustersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClustersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClustersRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)describeClustersRequest.clusterIdentifier()));
        }
        if (describeClustersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClustersRequest.maxRecords()));
        }
        if (describeClustersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClustersRequest.marker()));
        }
        if (describeClustersRequest.tagKeys().isEmpty() && !(describeClustersRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeClustersRequest.tagKeys().isEmpty() && !(describeClustersRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeClustersRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeClustersRequest.tagValues().isEmpty() && !(describeClustersRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeClustersRequest.tagValues().isEmpty() && !(describeClustersRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeClustersRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

