/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        if (createTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTagsRequest, "RedshiftClient");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTagsRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringConversion.fromString((String)createTagsRequest.resourceName()));
        }
        if (createTagsRequest.tags().isEmpty() && !(createTagsRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createTagsRequest.tags().isEmpty() && !(createTagsRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createTagsRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

