/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class DescribeDefaultClusterParametersPublisher
implements SdkPublisher<DescribeDefaultClusterParametersResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeDefaultClusterParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDefaultClusterParametersPublisher(RedshiftAsyncClient client, DescribeDefaultClusterParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDefaultClusterParametersPublisher(RedshiftAsyncClient client, DescribeDefaultClusterParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDefaultClusterParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDefaultClusterParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeDefaultClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.defaultClusterParameters() != null && response.defaultClusterParameters().parameters() != null) {
                return response.defaultClusterParameters().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDefaultClusterParametersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeDefaultClusterParametersPublisher resume(DescribeDefaultClusterParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDefaultClusterParametersPublisher(this.client, (DescribeDefaultClusterParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.defaultClusterParameters().marker()).build()));
        }
        return new DescribeDefaultClusterParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDefaultClusterParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDefaultClusterParametersResponseFetcher
    implements AsyncPageFetcher<DescribeDefaultClusterParametersResponse> {
        private DescribeDefaultClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDefaultClusterParametersResponse previousPage) {
            return previousPage.defaultClusterParameters().marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.defaultClusterParameters().marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.defaultClusterParameters().marker());
        }

        public CompletableFuture<DescribeDefaultClusterParametersResponse> nextPage(DescribeDefaultClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDefaultClusterParametersPublisher.this.client.describeDefaultClusterParameters(DescribeDefaultClusterParametersPublisher.this.firstRequest);
            }
            return DescribeDefaultClusterParametersPublisher.this.client.describeDefaultClusterParameters((DescribeDefaultClusterParametersRequest)((Object)DescribeDefaultClusterParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.defaultClusterParameters().marker()).build()));
        }
    }
}

