/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;

public class DescribeClusterSubnetGroupsPublisher
implements SdkPublisher<DescribeClusterSubnetGroupsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterSubnetGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterSubnetGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterSubnetGroup> clusterSubnetGroups() {
        Function<DescribeClusterSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSubnetGroups() != null) {
                return response.clusterSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterSubnetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeClusterSubnetGroupsPublisher resume(DescribeClusterSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSubnetGroupsPublisher(this.client, (DescribeClusterSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSubnetGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterSubnetGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterSubnetGroupsResponse> {
        private DescribeClusterSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<DescribeClusterSubnetGroupsResponse> nextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSubnetGroupsPublisher.this.client.describeClusterSubnetGroups(DescribeClusterSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeClusterSubnetGroupsPublisher.this.client.describeClusterSubnetGroups((DescribeClusterSubnetGroupsRequest)((Object)DescribeClusterSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

