/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;

public class DescribeClusterParameterGroupsIterable
implements SdkIterable<DescribeClusterParameterGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterParameterGroupsIterable(RedshiftClient client, DescribeClusterParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterParameterGroup> parameterGroups() {
        Function<DescribeClusterParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameterGroups() != null) {
                return response.parameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeClusterParameterGroupsIterable resume(DescribeClusterParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterParameterGroupsIterable(this.client, (DescribeClusterParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterParameterGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterParameterGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeClusterParameterGroupsResponse> {
        private DescribeClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParameterGroupsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeClusterParameterGroupsResponse nextPage(DescribeClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParameterGroupsIterable.this.client.describeClusterParameterGroups(DescribeClusterParameterGroupsIterable.this.firstRequest);
            }
            return DescribeClusterParameterGroupsIterable.this.client.describeClusterParameterGroups((DescribeClusterParameterGroupsRequest)((Object)DescribeClusterParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

