/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreFromClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String snapshotClusterIdentifier;
    private final Integer port;
    private final String availabilityZone;
    private final Boolean allowVersionUpgrade;
    private final String clusterSubnetGroupName;
    private final Boolean publiclyAccessible;
    private final String ownerAccount;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String elasticIp;
    private final String clusterParameterGroupName;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String preferredMaintenanceWindow;
    private final Integer automatedSnapshotRetentionPeriod;
    private final String kmsKeyId;
    private final String nodeType;
    private final Boolean enhancedVpcRouting;
    private final String additionalInfo;
    private final List<String> iamRoles;

    private RestoreFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.ownerAccount = builder.ownerAccount;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.elasticIp = builder.elasticIp;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.nodeType = builder.nodeType;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.additionalInfo = builder.additionalInfo;
        this.iamRoles = builder.iamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public List<String> iamRoles() {
        return this.iamRoles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotClusterIdentifier(), other.snapshotClusterIdentifier()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.clusterParameterGroupName(), other.clusterParameterGroupName()) && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.iamRoles(), other.iamRoles());
    }

    public String toString() {
        return ToString.builder((String)"RestoreFromClusterSnapshotRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SnapshotClusterIdentifier", (Object)this.snapshotClusterIdentifier()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("OwnerAccount", (Object)this.ownerAccount()).add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("ElasticIp", (Object)this.elasticIp()).add("ClusterParameterGroupName", (Object)this.clusterParameterGroupName()).add("ClusterSecurityGroups", this.clusterSecurityGroups()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NodeType", (Object)this.nodeType()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("AdditionalInfo", (Object)this.additionalInfo()).add("IamRoles", this.iamRoles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotClusterIdentifier()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AllowVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowVersionUpgrade()));
            }
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "ElasticIp": {
                return Optional.ofNullable(clazz.cast(this.elasticIp()));
            }
            case "ClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroupName()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "IamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String snapshotClusterIdentifier;
        private Integer port;
        private String availabilityZone;
        private Boolean allowVersionUpgrade;
        private String clusterSubnetGroupName;
        private Boolean publiclyAccessible;
        private String ownerAccount;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String elasticIp;
        private String clusterParameterGroupName;
        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private Integer automatedSnapshotRetentionPeriod;
        private String kmsKeyId;
        private String nodeType;
        private Boolean enhancedVpcRouting;
        private String additionalInfo;
        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromClusterSnapshotRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.ownerAccount(model.ownerAccount);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.elasticIp(model.elasticIp);
            this.clusterParameterGroupName(model.clusterParameterGroupName);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.kmsKeyId(model.kmsKeyId);
            this.nodeType(model.nodeType);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.additionalInfo(model.additionalInfo);
            this.iamRoles(model.iamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final Collection<String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromClusterSnapshotRequest build() {
            return new RestoreFromClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder ownerAccount(String var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder elasticIp(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder nodeType(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder additionalInfo(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

