/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.RecurringCharge;
import software.amazon.awssdk.services.redshift.model.ReservedNode;
import software.amazon.awssdk.services.redshift.transform.RecurringChargeUnmarshaller;

public class ReservedNodeUnmarshaller
implements Unmarshaller<ReservedNode, StaxUnmarshallerContext> {
    private static final ReservedNodeUnmarshaller INSTANCE = new ReservedNodeUnmarshaller();

    public ReservedNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedNode.Builder reservedNode;
        block16: {
            reservedNode = ReservedNode.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<RecurringCharge> recurringCharges = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reservedNode.recurringCharges(recurringCharges);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ReservedNodeId", targetDepth)) {
                        reservedNode.reservedNodeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReservedNodeOfferingId", targetDepth)) {
                        reservedNode.reservedNodeOfferingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeType", targetDepth)) {
                        reservedNode.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StartTime", targetDepth)) {
                        reservedNode.startTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Duration", targetDepth)) {
                        reservedNode.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("FixedPrice", targetDepth)) {
                        reservedNode.fixedPrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UsagePrice", targetDepth)) {
                        reservedNode.usagePrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CurrencyCode", targetDepth)) {
                        reservedNode.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeCount", targetDepth)) {
                        reservedNode.nodeCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("State", targetDepth)) {
                        reservedNode.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OfferingType", targetDepth)) {
                        reservedNode.offeringType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RecurringCharges", targetDepth)) {
                        recurringCharges = new ArrayList<RecurringCharge>();
                        continue;
                    }
                    if (!context.testExpression("RecurringCharges/RecurringCharge", targetDepth)) continue;
                    recurringCharges.add(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reservedNode.recurringCharges(recurringCharges);
        }
        return (ReservedNode)reservedNode.build();
    }

    public static ReservedNodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

