/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;

public class DescribeHsmConfigurationsIterable
implements SdkIterable<DescribeHsmConfigurationsResponse> {
    private final RedshiftClient client;
    private final DescribeHsmConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHsmConfigurationsIterable(RedshiftClient client, DescribeHsmConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHsmConfigurationsResponseFetcher();
    }

    public Iterator<DescribeHsmConfigurationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<HsmConfiguration> hsmConfigurations() {
        Function<DescribeHsmConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hsmConfigurations() != null) {
                return response.hsmConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeHsmConfigurationsIterable resume(DescribeHsmConfigurationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeHsmConfigurationsIterable(this.client, (DescribeHsmConfigurationsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeHsmConfigurationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeHsmConfigurationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeHsmConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeHsmConfigurationsResponse> {
        private DescribeHsmConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmConfigurationsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeHsmConfigurationsResponse nextPage(DescribeHsmConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmConfigurationsIterable.this.client.describeHsmConfigurations(DescribeHsmConfigurationsIterable.this.firstRequest);
            }
            return DescribeHsmConfigurationsIterable.this.client.describeHsmConfigurations((DescribeHsmConfigurationsRequest)((Object)DescribeHsmConfigurationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

