/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscription;

public class DescribeEventSubscriptionsIterable
implements SdkIterable<DescribeEventSubscriptionsResponse> {
    private final RedshiftClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventSubscriptionsIterable(RedshiftClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeEventSubscriptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<EventSubscription> eventSubscriptionsList() {
        Function<DescribeEventSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSubscriptionsList() != null) {
                return response.eventSubscriptionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeEventSubscriptionsIterable resume(DescribeEventSubscriptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventSubscriptionsIterable(this.client, (DescribeEventSubscriptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventSubscriptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventSubscriptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements SyncPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeEventSubscriptionsResponse nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions(DescribeEventSubscriptionsIterable.this.firstRequest);
            }
            return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

